/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.UUID;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Vector3f;
import ru.astemir.astemirlib.client.DeferredEntityRenderer;
import ru.astemir.astemirlib.client.RenderUtils;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.client.event.HumanoidPoseEvent;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.common.entity.entity.water.EntityDunkleosteus;

public class DunkleosteusModel
extends TDEEntityModel<EntityDunkleosteus> {
    private static final String ID = "dunkleosteus";
    private static final ResourceLocation TEXTURE_MALE = DunkleosteusModel.textureLocation("dunkleosteus", "male.png");
    private static final ResourceLocation TEXTURE_FEMALE = DunkleosteusModel.textureLocation("dunkleosteus", "female.png");
    private static final ResourceLocation TEXTURE_BABY = DunkleosteusModel.textureLocation("dunkleosteus", "baby.png");

    public DunkleosteusModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
    }

    public void animate(Animator animator, EntityDunkleosteus entity, EntityRenderData renderData) {
        Animation animation = animator.getAnimation("animation.model.swim");
        if (!entity.m_20069_()) {
            animation = animator.getAnimation("animation.model.land");
        }
        if (entity.actionController.is(new ActionState[]{entity.actionAttackBite, entity.actionEat})) {
            animation = animation.merge(animator.getAnimation("animation.model.attack1"));
        } else if (entity.actionController.is(entity.actionAttackHead)) {
            animation = animation.merge(animator.getAnimation("animation.model.attack2"));
        }
        float bodyRotDeviation = ((Double)entity.bodyRotDeviation.get(renderData.partialTick)).floatValue();
        float xRotDeviation = ((Double)entity.xRotDeviation.get(renderData.partialTick)).floatValue();
        float bellyScale = ((Double)entity.clientPregnancyScale.get(renderData.partialTick)).floatValue();
        animator.getTransform(ID).setCustomRotation(this.clamp(renderData.entityPitch + xRotDeviation, -90.0f, 90.0f), 0.0f, 0.0f);
        animator.getTransform("belly").setCustomPosition(0.0f, (1.0f - bellyScale) * 12.0f, 0.0f);
        animator.getTransform("belly").setCustomScale(1.0f, bellyScale, 1.0f);
        animator.getTransform("tail").setCustomRotation(xRotDeviation, -bodyRotDeviation, 0.0f);
        animator.getTransform("tail1").setCustomRotation(xRotDeviation, -bodyRotDeviation * 2.0f, 0.0f);
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.15f), 1.0, 1);
        if (entity.actionController.is(entity.actionEat)) {
            this.renderFoodParticles(entity, this, renderData, "head");
        }
    }

    @Override
    public void renderPassenger(EntityDunkleosteus entity, LivingEntity passenger) {
        PoseStack poseStack = RenderUtils.fromPose((PoseStack.Pose)this.getPart("body").getLastPose());
        DeferredEntityRenderer.renderDeferred((UUID)passenger.m_20148_(), (PoseStack)poseStack, (AVector3f)new AVector3f(0.0f, 1.4f, 0.5f), (float)0.0f);
    }

    @Override
    public boolean applyPassengerRotation(EntityDunkleosteus entity, LivingEntity passenger, PoseStack poseStack, float passengerRotation) {
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-110.0f));
        return super.applyPassengerRotation(entity, passenger, poseStack, passengerRotation);
    }

    @Override
    public void applyPassengerPose(EntityDunkleosteus entity, LivingEntity passenger, HumanoidPoseEvent event, float ageInTicks, float partialTick) {
        event.head.m_252899_(new Vector3f(this.rad(-90.0f), 0.0f, 0.0f));
        event.hat.m_252899_(new Vector3f(this.rad(-90.0f), 0.0f, 0.0f));
        event.body.m_252899_(new Vector3f(this.rad(-30.0f), 0.0f, 0.0f));
        event.leftArm.m_252899_(new Vector3f(-this.rad(150.0f), this.rad(90.0f), this.rad(40.0f)));
        event.rightArm.m_252899_(new Vector3f(-this.rad(150.0f), -this.rad(90.0f), -this.rad(40.0f)));
        event.leftLeg.m_252854_(new Vector3f(0.0f, -4.0f, -4.0f));
        event.rightLeg.m_252854_(new Vector3f(0.0f, -4.0f, -4.0f));
        event.leftLeg.m_252899_(new Vector3f(-this.sin(ageInTicks / 2.0f) / 2.0f, 0.0f, -this.rad(20.0f)));
        event.rightLeg.m_252899_(new Vector3f(this.sin(ageInTicks / 2.0f) / 2.0f, 0.0f, this.rad(20.0f)));
    }

    public ResourceLocation getTexture(EntityDunkleosteus object) {
        if (object.m_6162_()) {
            return TEXTURE_BABY;
        }
        switch (object.getGender()) {
            case MALE: {
                return TEXTURE_MALE;
            }
            case FEMALE: {
                return TEXTURE_FEMALE;
            }
        }
        return TEXTURE_MALE;
    }

    public static TDELivingRenderer<EntityDunkleosteus> createRenderer(EntityRendererProvider.Context context) {
        DunkleosteusModel model = new DunkleosteusModel(DunkleosteusModel.modelLocation(ID, "geo.json"), DunkleosteusModel.animationsLocation(ID, "animation.json"));
        DunkleosteusModel babyModel = new DunkleosteusModel(DunkleosteusModel.modelLocation(ID, "geo_baby.json"), DunkleosteusModel.animationsLocation(ID, "animation_baby.json"));
        return TDELivingRenderer.createRendererGendered(context, mob -> model, mob -> babyModel, 0.6f, 1.0f);
    }
}

