/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import ru.astemir.astemirlib.client.RenderUtils;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModelLayer;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.common.entity.entity.water.EntityMixosaurus;

public class MixosaurusModel
extends TDEEntityModel<EntityMixosaurus> {
    private static final String ID = "mixosaurus";
    private static final ResourceLocation TEXTURE_MALE = MixosaurusModel.textureLocation("mixosaurus", "male.png");
    private static final ResourceLocation TEXTURE_FEMALE = MixosaurusModel.textureLocation("mixosaurus", "female.png");
    private static final ResourceLocation TEXTURE_BABY = MixosaurusModel.textureLocation("mixosaurus", "baby.png");

    public MixosaurusModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
        this.addLayer((BedrockModelLayer)new BedrockModelLayer<EntityMixosaurus>((BedrockModel)this){

            public void render(EntityMixosaurus object, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
                ItemStack itemStack = object.m_21120_(InteractionHand.MAIN_HAND);
                if (itemStack != null && itemStack != ItemStack.f_41583_) {
                    PoseStack itemPose = RenderUtils.fromPose((PoseStack.Pose)this.getModel().getPart("jaw").getLastPose());
                    itemPose.m_252880_(-0.05f, 0.0f, -0.45f);
                    itemPose.m_252781_(Axis.f_252436_.m_252977_(45.0f));
                    itemPose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    this.renderItem((Entity)object, itemStack, ItemDisplayContext.GROUND, itemPose, bufferSource, packedLight);
                }
            }
        });
    }

    public void animate(Animator animator, EntityMixosaurus entity, EntityRenderData renderData) {
        Animation animation = animator.getAnimation("animation.model.swim");
        if (!entity.m_20069_() && !entity.actionController.is(entity.actionJump)) {
            animation = animator.getAnimation("animation.model.land");
        }
        if (entity.actionController.is(new ActionState[]{entity.actionAttack, entity.actionEat})) {
            animation = animator.getAnimation("animation.model.attack");
        }
        float bodyRotDeviation = ((Double)entity.bodyRotDeviation.get(renderData.partialTick)).floatValue();
        float xRotDeviation = ((Double)entity.xRotDeviation.get(renderData.partialTick)).floatValue();
        float bellyScale = ((Double)entity.clientPregnancyScale.get(renderData.partialTick)).floatValue();
        animator.getTransform("body").setCustomRotation(renderData.entityPitch, 0.0f, 0.0f);
        animator.getTransform("belly").setCustomPosition(0.0f, (1.0f - bellyScale) * 12.0f, 0.0f);
        animator.getTransform("belly").setCustomScale(1.0f, bellyScale, 1.0f);
        animator.getTransform("head").setCustomRotation(-xRotDeviation, bodyRotDeviation * 2.0f, 0.0f);
        animator.getTransform("tail").setCustomRotation(0.0f, -bodyRotDeviation * 2.0f, 0.0f);
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.1), 1.0, 1);
        if (entity.actionController.is(entity.actionEat)) {
            this.renderFoodParticles(entity, this, renderData, "head");
        }
    }

    public ResourceLocation getTexture(EntityMixosaurus object) {
        if (object.m_6162_()) {
            return TEXTURE_BABY;
        }
        switch (object.getGender()) {
            case MALE: {
                return TEXTURE_MALE;
            }
            case FEMALE: {
                return TEXTURE_FEMALE;
            }
        }
        return TEXTURE_MALE;
    }

    public static TDELivingRenderer<EntityMixosaurus> createRenderer(EntityRendererProvider.Context context) {
        MixosaurusModel model = new MixosaurusModel(MixosaurusModel.modelLocation(ID, "geo.json"), MixosaurusModel.animationsLocation(ID, "animation.json"));
        MixosaurusModel babyModel = new MixosaurusModel(MixosaurusModel.modelLocation(ID, "geo_baby.json"), MixosaurusModel.animationsLocation(ID, "animation_baby.json"));
        return TDELivingRenderer.createRendererGendered(context, mob -> model, mob -> babyModel, 0.3f, 1.0f);
    }
}

