/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import ru.astemir.astemirlib.client.bedrock.animation.Animated;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.animation.data.PartTransform;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.xishnikus.thedawnera.client.misc.MobModelResources;
import ru.xishnikus.thedawnera.client.misc.ModelResource;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityPondSnail;

public class PondSnailModel
extends TDEEntityModel<EntityPondSnail> {
    private static final String ID = "snail";
    private static final MobModelResources<EntityPondSnail> modelResources = new MobModelResources<EntityPondSnail>(new ModelResource<EntityPondSnail>(new PondSnailModel(PondSnailModel.modelLocation("snail", "geo.json"), PondSnailModel.animationsLocation("snail", "animation.json")), PondSnailModel.textureLocation("snail", "snail.png"))).add(new ModelResource<EntityPondSnail>(new PondSnailModel(PondSnailModel.modelLocation("snail", "geo_croc.json"), PondSnailModel.animationsLocation("snail", "animation.json")), PondSnailModel.textureLocation("snail", "snail_croc.png")).customNameCondition("Mr.CrocMimic")).add(new ModelResource<EntityPondSnail>(new PondSnailModel(PondSnailModel.modelLocation("snail", "geo_jorik.json"), PondSnailModel.animationsLocation("snail", "animation.json")), PondSnailModel.textureLocation("snail", "snail_jorik.png")).customNameCondition("Jorik")).add(new ModelResource<EntityPondSnail>(new PondSnailModel(PondSnailModel.modelLocation("snail", "geo_grnk.json"), PondSnailModel.animationsLocation("snail", "animation.json")), PondSnailModel.textureLocation("snail", "snail_grnk.png")).customNameCondition("Grnk")).add(new ModelResource<EntityPondSnail>(new PondSnailModel(PondSnailModel.modelLocation("snail", "geo_bocche.json"), PondSnailModel.animationsLocation("snail", "animation.json")), PondSnailModel.textureLocation("snail", "snail_bocche.png")).customNameCondition("PRIMAL")).add(new ModelResource<EntityPondSnail>(new PondSnailModel(PondSnailModel.modelLocation("snail", "geo_skull.json"), PondSnailModel.animationsLocation("snail", "animation.json")), PondSnailModel.textureLocation("snail", "snail_skull.png")).customNameCondition("Anchor"));

    public PondSnailModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
    }

    public void animate(Animator animator, EntityPondSnail entity, EntityRenderData renderData) {
        Animation animation = animator.getAnimation("animation.model.idle");
        if (this.isMoving((LivingEntity)entity, -0.01f, 0.01f, renderData.partialTick)) {
            animation = animator.getAnimation("animation.model.walk");
        }
        if (entity.actionController.is(entity.actionHide)) {
            animation = animator.getAnimation("animation.model.hide");
        } else if (entity.actionController.is(entity.actionOpen)) {
            animation = animator.getAnimation("animation.model.open");
        }
        Direction attachmentDir = entity.getAttachmentFacing();
        Direction prevAttachment = entity.getPreviousAttachmentDirection();
        PartTransform mainTransform = animator.getTransform(ID);
        AVector3f climbRot = new AVector3f(0.0f, 0.0f, 0.0f);
        AVector3f climbPos = new AVector3f(0.0f, 0.0f, 0.0f);
        if (entity.isClimbing()) {
            float f = climbRot.z = entity.m_20184_().f_82480_ < 0.0 ? 180.0f : 0.0f;
            if (attachmentDir != Direction.DOWN) {
                climbRot.x = -90.0f;
                climbPos.z = -3.5f;
            }
            if (attachmentDir == Direction.UP) {
                climbPos.z = 0.0f;
                climbPos.y = 8.0f;
                climbRot.x = -180.0f;
                climbRot.y = prevAttachment.m_122435_() + 90.0f;
            }
        }
        mainTransform.setCustomPosition(mainTransform.getCustomPosition().interpolate(climbPos, InterpolationType.LINEAR, renderData.partialTick / 100.0f));
        mainTransform.setCustomRotation(Mth.m_14189_((float)(renderData.partialTick / 100.0f), (float)mainTransform.getCustomRotation().x, (float)climbRot.x), Mth.m_14189_((float)(renderData.partialTick / 100.0f), (float)mainTransform.getCustomRotation().y, (float)climbRot.y), Mth.m_14189_((float)(renderData.partialTick / 100.0f), (float)mainTransform.getCustomRotation().z, (float)climbRot.z));
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.3), 1.0, 1);
    }

    public void renderFinal(BedrockModel model, EntityPondSnail object, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Color color) {
        if (object.m_6162_()) {
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        }
        super.renderFinal(model, (Animated)object, poseStack, bufferSource, packedLight, packedOverlay, color);
    }

    public ResourceLocation getTexture(EntityPondSnail object) {
        return modelResources.chooseTexture(object);
    }

    public static TDELivingRenderer<EntityPondSnail> createRenderer(EntityRendererProvider.Context context) {
        return TDELivingRenderer.createDefaultRenderer(context, snail -> modelResources.chooseModel((EntityPondSnail)snail), 0.2f, 0.75f);
    }
}

