/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import ru.astemir.astemirlib.client.RenderUtils;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModelLayer;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.xishnikus.thedawnera.client.misc.MobModelResources;
import ru.xishnikus.thedawnera.client.misc.ModelResource;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityPsittacosaurus;

public class PsittacosaurusModel
extends TDEEntityModel<EntityPsittacosaurus> {
    private static final String ID = "psittacosaurus";
    private static final PsittacosaurusModel MODEL = new PsittacosaurusModel(PsittacosaurusModel.modelLocation("psittacosaurus", "geo.json"), PsittacosaurusModel.animationsLocation("psittacosaurus", "animation.json"));
    private static final PsittacosaurusModel PINK_MODEL = new PsittacosaurusModel(PsittacosaurusModel.modelLocation("psittacosaurus", "geo_pink.json"), PsittacosaurusModel.animationsLocation("psittacosaurus", "animation.json"));
    private static final PsittacosaurusModel BABY_MODEL = new PsittacosaurusModel(PsittacosaurusModel.modelLocation("psittacosaurus", "geo_baby.json"), PsittacosaurusModel.animationsLocation("psittacosaurus", "animation_baby.json"));
    private static final MobModelResources<EntityPsittacosaurus> modelResources = new MobModelResources<EntityPsittacosaurus>(new ModelResource<EntityPsittacosaurus>(MODEL, BABY_MODEL, PsittacosaurusModel.textureLocation("psittacosaurus", "male.png"), PsittacosaurusModel.textureLocation("psittacosaurus", "female.png"), PsittacosaurusModel.textureLocation("psittacosaurus", "baby.png"))).add(new ModelResource<EntityPsittacosaurus>(PINK_MODEL, BABY_MODEL, PsittacosaurusModel.textureLocation("psittacosaurus", "pink.png"), PsittacosaurusModel.textureLocation("psittacosaurus", "pink.png"), PsittacosaurusModel.textureLocation("psittacosaurus", "baby.png")).customNameCondition("Rain"));

    public PsittacosaurusModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
        this.addLayer((BedrockModelLayer)new BedrockModelLayer<EntityPsittacosaurus>((BedrockModel)this){

            public void render(EntityPsittacosaurus entity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
                if (entity.actionController.is(entity.actionEat) && entity.getLastEatenFood() != null) {
                    PoseStack itemPoseStack = RenderUtils.fromPose((PoseStack.Pose)this.getModel().getPart("item").getLastPose());
                    if (entity.m_6162_()) {
                        itemPoseStack.m_252880_(0.0f, 0.0f, -0.1f);
                    } else {
                        itemPoseStack.m_252880_(0.05f, 0.0f, -0.35f);
                    }
                    this.renderItem((Entity)entity, entity.getLastEatenFood(), ItemDisplayContext.GROUND, itemPoseStack, bufferSource, packedLight);
                }
            }
        });
    }

    public void animate(Animator animator, EntityPsittacosaurus entity, EntityRenderData entityRenderData) {
        Animation animation = animator.getAnimation("animation.model.idle");
        if (this.isMoving((LivingEntity)entity, -0.1f, 0.1f, entityRenderData.partialTick)) {
            animation = animator.getAnimation("animation.model.walk");
        }
        if (this.isMoving((LivingEntity)entity, -0.5f, 0.5f, entityRenderData.partialTick)) {
            animation = animator.getAnimation("animation.model.run");
        }
        if (entity.m_20069_()) {
            animation = animator.getAnimation("animation.model.swim");
        }
        if (entity.actionController.is(entity.actionEat)) {
            animation = animator.getAnimation("animation.model.eat");
        }
        if (entity.actionController.is(entity.actionScream)) {
            animation = animator.getAnimation("animation.model.scream");
        }
        if (entity.actionController.is(entity.actionAttack)) {
            animation = animator.getAnimation("animation.model.attack");
        }
        if (entity.actionController.is(entity.actionBush)) {
            animation = animator.getAnimation("animation.model.bush");
        }
        if (entity.actionController.is(entity.actionDown)) {
            animation = animator.getAnimation("animation.model.down");
        }
        if (entity.stateController.is(entity.actionRest)) {
            animation = animator.getAnimation("animation.model.rest");
        }
        if (entity.actionController.is(entity.actionStartSleeping)) {
            animation = animator.getAnimation("animation.model.fall_asleep");
        }
        if (entity.stateController.is(entity.actionSleep)) {
            animation = animator.getAnimation("animation.model.sleep");
        }
        if (entity.actionController.is(entity.actionWakeUp)) {
            animation = animator.getAnimation("animation.model.wake_up");
        }
        if (entity.actionController.is(entity.actionUp)) {
            animation = animator.getAnimation("animation.model.up");
        }
        animator.getTransform("neck1").setLookAt(this.clamp(entityRenderData.entityYaw, -30.0f, 30.0f), entityRenderData.entityPitch);
        animator.getTransform("body").setLookAt(this.clamp(entityRenderData.entityYaw, -20.0f, 20.0f), 0.0f);
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.15f), 1.0, 1);
        if (entity.actionController.is(entity.actionEat) && entity.actionController.getTicks() < 40) {
            this.renderFoodParticles(entity, this, entityRenderData, new AVector3f(0.0f, 0.0f, 0.25f), new AVector3f(0.2f, 0.2f, 0.2f), 7, "head");
        }
    }

    public ResourceLocation getTexture(EntityPsittacosaurus entity) {
        return modelResources.chooseTexture(entity);
    }

    public static TDELivingRenderer<EntityPsittacosaurus> createRenderer(EntityRendererProvider.Context context) {
        return TDELivingRenderer.createRendererGendered(context, mob -> modelResources.chooseModel((EntityPsittacosaurus)mob), mob -> modelResources.chooseModel((EntityPsittacosaurus)mob), 0.4f, 1.0f);
    }
}

