/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.common.entity.entity.water.EntitySabertoothSalmon;

public class SabertoothSalmonModel
extends TDEEntityModel<EntitySabertoothSalmon> {
    private static final String ID = "sabertooth_salmon";
    private static final ResourceLocation TEXTURE_MALE = SabertoothSalmonModel.textureLocation("sabertooth_salmon", "male.png");
    private static final ResourceLocation TEXTURE_FEMALE = SabertoothSalmonModel.textureLocation("sabertooth_salmon", "female.png");
    private static final ResourceLocation TEXTURE_BABY = SabertoothSalmonModel.textureLocation("sabertooth_salmon", "baby.png");

    public SabertoothSalmonModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
    }

    public void animate(Animator animator, EntitySabertoothSalmon entity, EntityRenderData renderData) {
        Animation animation = animator.getAnimation("animation.model.swim");
        if (!entity.m_20069_() && !entity.actionController.is(entity.actionJump)) {
            animation = animator.getAnimation("animation.model.land");
        }
        if (entity.actionController.is(new ActionState[]{entity.actionAttack, entity.actionEat})) {
            animation = animator.getAnimation("animation.model.attack");
        }
        float bodyRotDeviation = ((Double)entity.bodyRotDeviation.get(renderData.partialTick)).floatValue();
        float bellyScale = ((Double)entity.clientPregnancyScale.get(renderData.partialTick)).floatValue();
        animator.getTransform("salmon").setCustomRotation(this.clamp(renderData.entityPitch, -90.0f, 90.0f), 0.0f, 0.0f);
        animator.getTransform("belly").setCustomPosition(0.0f, (1.0f - bellyScale) * 12.0f, 0.0f);
        animator.getTransform("belly").setCustomScale(1.0f, bellyScale, 1.0f);
        animator.getTransform("head").setCustomRotation(0.0f, bodyRotDeviation, 0.0f);
        animator.getTransform("tail1").setCustomRotation(0.0f, -bodyRotDeviation * 2.0f, 0.0f);
        animator.getTransform("tail2").setCustomRotation(0.0f, -bodyRotDeviation * 3.0f, 0.0f);
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.1), 1.0, 1);
        if (entity.actionController.is(entity.actionEat)) {
            this.renderFoodParticles(entity, this, renderData, "head");
        }
    }

    public ResourceLocation getTexture(EntitySabertoothSalmon entity) {
        if (entity.m_6162_()) {
            return TEXTURE_BABY;
        }
        switch (entity.getGender()) {
            case MALE: {
                return TEXTURE_MALE;
            }
            case FEMALE: {
                return TEXTURE_FEMALE;
            }
        }
        return TEXTURE_MALE;
    }

    public static TDELivingRenderer<EntitySabertoothSalmon> createRenderer(EntityRendererProvider.Context context) {
        SabertoothSalmonModel model = new SabertoothSalmonModel(SabertoothSalmonModel.modelLocation(ID, "geo.json"), SabertoothSalmonModel.animationsLocation(ID, "animation.json"));
        SabertoothSalmonModel babyModel = new SabertoothSalmonModel(SabertoothSalmonModel.modelLocation(ID, "geo_baby.json"), SabertoothSalmonModel.animationsLocation(ID, "animation_baby.json"));
        return TDELivingRenderer.createRendererGendered(context, mob -> model, mob -> babyModel, 0.3f, 1.0f);
    }
}

