/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import ru.astemir.astemirlib.client.DeferredEntityRenderer;
import ru.astemir.astemirlib.client.RenderUtils;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.model.BedrockEntityModel;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.client.event.HumanoidPoseEvent;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.astemir.astemirlib.common.world.WorldUtils;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.common.entity.entity.water.EntitySachicasaurus;
import ru.xishnikus.thedawnera.common.io.config.TDEClientConfig;
import ru.xishnikus.thedawnera.common.particle.TDEParticleTypes;

public class SachicasaurusModel
extends TDEEntityModel<EntitySachicasaurus> {
    private static final String ID = "sachicasaurus";
    private static final ResourceLocation TEXTURE_MALE = SachicasaurusModel.textureLocation("sachicasaurus", "male.png");
    private static final ResourceLocation TEXTURE_FEMALE = SachicasaurusModel.textureLocation("sachicasaurus", "female.png");
    private static final ResourceLocation TEXTURE_BABY = SachicasaurusModel.textureLocation("sachicasaurus", "baby.png");

    public SachicasaurusModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
    }

    public void animate(Animator animator, EntitySachicasaurus entity, EntityRenderData entityRenderData) {
        Animation animation = animator.getAnimation("animation.model.swim");
        if (!entity.m_20069_()) {
            animation = animator.getAnimation("animation.model.land");
            if (this.isMoving((Entity)entity, -0.05f, 0.05f)) {
                animation = animator.getAnimation("animation.model.walk");
            }
        }
        if (entity.actionController.is(entity.actionRoar)) {
            animation = animator.getAnimation("animation.model.roar");
        }
        if (entity.actionController.is(entity.actionAttack1)) {
            animation = animator.getAnimation("animation.model.attack1");
        }
        if (entity.actionController.is(entity.actionAttack2)) {
            animation = animator.getAnimation("animation.model.attack2");
        }
        float speed = 1.0f;
        if (entity.actionController.is(entity.actionOpen)) {
            animation = animator.getAnimation("animation.model.open");
            speed = 0.5f;
        }
        if (entity.isCharged()) {
            animation = animator.getAnimation("animation.model.charge");
        }
        if (entity.actionController.is(entity.actionClose)) {
            animation = animator.getAnimation("animation.model.close");
        }
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.15f), (double)speed, 1);
        float bodyRotDeviation = ((Double)entity.bodyRotDeviation.get(entityRenderData.partialTick)).floatValue();
        animator.getTransform("head").setCustomRotation(0.0f, bodyRotDeviation, 0.0f);
        animator.getTransform("tail1").setCustomRotation(0.0f, -bodyRotDeviation * 2.0f, 0.0f);
        animator.getTransform("tail2").setCustomRotation(0.0f, -bodyRotDeviation * 3.0f, 0.0f);
        animator.getTransform("Sachicasaurus").setCustomRotation(this.clamp(entityRenderData.entityPitch, -90.0f, 90.0f), 0.0f, 0.0f);
        this.renderRoarParticles(entity, entityRenderData);
        if (entity.actionController.is(new ActionState[]{entity.actionEat1, entity.actionEat2}) && entity.actionController.getTicks() > 30 && entity.actionController.getTicks() < 50 && entity.getLastEatenFood() != null) {
            if (entity.m_6162_()) {
                this.renderFoodParticles(entity, this, entityRenderData, new AVector3f(0.0f, 0.0f, -0.35f), new AVector3f(0.4f, 0.35f, 0.4f), 5, "head");
            } else {
                this.renderFoodParticles(entity, this, entityRenderData, new AVector3f(0.0f, 0.0f, -1.0f), new AVector3f(0.8f, 0.7f, 0.8f), 3, "head");
            }
        }
    }

    public void renderRoarParticles(EntitySachicasaurus entity, EntityRenderData entityRenderData) {
        if (entity.actionController.is(entity.actionRoar) && !entity.m_6162_() && entity.actionController.getTicks() > 10 && entity.actionController.getTicks() < 35) {
            this.renderBubbleRoarParticles((LivingEntity)entity, this, entityRenderData, "body", new AVector3f(0.0f, 0.75f, -3.0f), 0.25f, 0.25f, 5);
        }
    }

    public void renderBubbleRoarParticles(LivingEntity entity, BedrockEntityModel model, EntityRenderData entityRenderData, String bone, AVector3f offset, float minRadius, float radiusMultiplier, int distance) {
        if (!Minecraft.m_91087_().m_91104_() && ((Boolean)TDEClientConfig.SHOW_ROAR_PARTICLES.get()).booleanValue()) {
            PoseStack particlePoseStack = model.getBonePose(entityRenderData, entity, bone);
            AVector3f renderRot = model.getBoneRotation(entityRenderData, entity, bone);
            float radius = minRadius + MathUtils.abs((float)MathUtils.sin((float)(entityRenderData.ageInTicks / 4.0f))) * radiusMultiplier;
            float f1 = MathUtils.cos((float)entityRenderData.ageInTicks) / 4.0f;
            float f2 = MathUtils.sin((float)entityRenderData.ageInTicks) / 4.0f;
            particlePoseStack.m_85837_((double)offset.x, (double)offset.y - 0.5 - (double)(radius / 2.0f), (double)(offset.z - radius));
            for (int i = 0; i < distance; ++i) {
                particlePoseStack.m_252880_(-MathUtils.cos((float)entityRenderData.ageInTicks) * radius, MathUtils.sin((float)entityRenderData.ageInTicks) * radius, (float)(-i) * 0.6f);
                AVector3f vec = AVector3f.from((Vector3f)particlePoseStack.m_85850_().m_252922_().getTranslation(new Vector3f()));
                Vec3 pos = new Vec3((double)(vec.x + RandomUtils.randomFloat((float)-0.1f, (float)0.1f)), (double)(vec.y + RandomUtils.randomFloat((float)-0.1f, (float)0.1f)), (double)(vec.z + RandomUtils.randomFloat((float)-0.1f, (float)0.1f)));
                entity.m_9236_().m_7106_((ParticleOptions)(entity.m_9236_().m_6425_(WorldUtils.blockPos((Vec3)pos)).m_192917_((Fluid)Fluids.f_76193_) ? ParticleTypes.f_123795_ : (ParticleOptions)TDEParticleTypes.WIND.get()), pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)(renderRot.x + f1 * radius / 2.0f), (double)(renderRot.y + f2 * radius / 2.0f), (double)(renderRot.z + f1 * radius / 2.0f));
            }
        }
    }

    @Override
    public void applyPassengerPose(EntitySachicasaurus entity, LivingEntity passenger, HumanoidPoseEvent event, float ageInTicks, float partialTick) {
        event.head.m_252899_(new Vector3f(this.rad(-90.0f), 0.0f, 0.0f));
        event.hat.m_252899_(new Vector3f(this.rad(-90.0f), 0.0f, 0.0f));
        event.body.m_252899_(new Vector3f(this.rad(-30.0f), 0.0f, 0.0f));
        event.leftArm.m_252899_(new Vector3f(-this.rad(150.0f), this.rad(90.0f), this.rad(40.0f)));
        event.rightArm.m_252899_(new Vector3f(-this.rad(150.0f), -this.rad(90.0f), -this.rad(40.0f)));
        event.leftLeg.m_252854_(new Vector3f(0.0f, -4.0f, -4.0f));
        event.rightLeg.m_252854_(new Vector3f(0.0f, -4.0f, -4.0f));
        event.leftLeg.m_252899_(new Vector3f(-this.sin(ageInTicks / 2.0f) / 2.0f, 0.0f, -this.rad(20.0f)));
        event.rightLeg.m_252899_(new Vector3f(this.sin(ageInTicks / 2.0f) / 2.0f, 0.0f, this.rad(20.0f)));
    }

    @Override
    public boolean applyPassengerRotation(EntitySachicasaurus entity, LivingEntity passenger, PoseStack poseStack, float passengerRotation) {
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-110.0f));
        return super.applyPassengerRotation(entity, passenger, poseStack, passengerRotation);
    }

    @Override
    public void renderPassenger(EntitySachicasaurus entity, LivingEntity passenger) {
        PoseStack poseStack = RenderUtils.fromPose((PoseStack.Pose)this.getPart("body").getLastPose());
        int i = entity.m_20197_().indexOf(passenger);
        DeferredEntityRenderer.renderDeferred((UUID)passenger.m_20148_(), (PoseStack)poseStack, (AVector3f)new AVector3f(0.0f, 1.55f, 0.35f + (float)i * 1.3f), (float)0.0f);
    }

    public ResourceLocation getTexture(EntitySachicasaurus entity) {
        if (entity.m_6162_()) {
            return TEXTURE_BABY;
        }
        switch (entity.getGender()) {
            case MALE: {
                return TEXTURE_MALE;
            }
            case FEMALE: {
                return TEXTURE_FEMALE;
            }
        }
        return TEXTURE_MALE;
    }

    public static TDELivingRenderer<EntitySachicasaurus> createRenderer(EntityRendererProvider.Context context) {
        SachicasaurusModel model = new SachicasaurusModel(SachicasaurusModel.modelLocation(ID, "geo.json"), SachicasaurusModel.animationsLocation(ID, "animation.json"));
        return TDELivingRenderer.createRendererGendered(context, mob -> model, mob -> model, 2.0f, 1.0f);
    }
}

