/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityStruthiomimus;

public class StruthiomimusModel
extends TDEEntityModel<EntityStruthiomimus> {
    private static final String ID = "struthiomimus";
    private static final ResourceLocation TEXTURE_MALE = StruthiomimusModel.textureLocation("struthiomimus", "male.png");
    private static final ResourceLocation TEXTURE_FEMALE = StruthiomimusModel.textureLocation("struthiomimus", "female.png");
    private static final ResourceLocation TEXTURE_BABY = StruthiomimusModel.textureLocation("struthiomimus", "baby.png");

    public StruthiomimusModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
    }

    public void animate(Animator animator, EntityStruthiomimus entity, EntityRenderData entityRenderData) {
        Animation animation = animator.getAnimation("animation.model.idle");
        if (this.isMoving((LivingEntity)entity, -0.1f, 0.1f, entityRenderData.partialTick)) {
            animation = animator.getAnimation("animation.model.walk");
        }
        if (this.isMoving((LivingEntity)entity, -0.5f, 0.5f, entityRenderData.partialTick)) {
            animation = animator.getAnimation("animation.model.run");
        }
        if (entity.m_20069_()) {
            animation = animator.getAnimation("animation.model.swim");
        }
        if (entity.actionController.is(entity.actionEat)) {
            animation = animator.getAnimation("animation.model.eat");
        } else if (entity.actionController.is(entity.actionScream)) {
            animation = animator.getAnimation("animation.model.scream");
        }
        if (entity.actionController.is(entity.actionAttack)) {
            animation = animation.merge(animator.getAnimation("animation.model.attack"));
        }
        if (entity.actionController.is(entity.actionDown)) {
            animation = animator.getAnimation("animation.model.down");
        }
        if (entity.stateController.is(entity.actionRest)) {
            animation = animator.getAnimation("animation.model.rest");
        }
        if (entity.actionController.is(entity.actionStartSleeping)) {
            animation = animator.getAnimation("animation.model.fall_asleep");
        }
        if (entity.stateController.is(entity.actionSleep)) {
            animation = animator.getAnimation("animation.model.sleep");
        }
        if (entity.actionController.is(entity.actionWakeUp)) {
            animation = animator.getAnimation("animation.model.wake_up");
        }
        if (entity.actionController.is(entity.actionUp)) {
            animation = animator.getAnimation("animation.model.up");
        }
        animator.getTransform("neck1").setLookAt(this.clamp(entityRenderData.entityYaw, -30.0f, 30.0f), entityRenderData.entityPitch);
        animator.getTransform("body").setLookAt(this.clamp(entityRenderData.entityYaw, -20.0f, 20.0f), 0.0f);
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.15f), 1.0, 1);
        if (entity.actionController.is(entity.actionEat) && entity.actionController.getTicks() < 20) {
            this.renderFoodParticles(entity, this, entityRenderData, new AVector3f(0.0f, -0.2f, 0.1f), new AVector3f(0.3f, 0.4f, 0.3f), 6, "head");
        }
    }

    public ResourceLocation getTexture(EntityStruthiomimus entity) {
        if (entity.m_6162_()) {
            return TEXTURE_BABY;
        }
        switch (entity.getGender()) {
            case MALE: {
                return TEXTURE_MALE;
            }
            case FEMALE: {
                return TEXTURE_FEMALE;
            }
        }
        return TEXTURE_MALE;
    }

    public static TDELivingRenderer<EntityStruthiomimus> createRenderer(EntityRendererProvider.Context context) {
        StruthiomimusModel model = new StruthiomimusModel(StruthiomimusModel.modelLocation(ID, "geo.json"), StruthiomimusModel.animationsLocation(ID, "animation.json"));
        StruthiomimusModel babyModel = new StruthiomimusModel(StruthiomimusModel.modelLocation(ID, "geo_baby.json"), StruthiomimusModel.animationsLocation(ID, "animation_baby.json"));
        return TDELivingRenderer.createRendererGendered(context, mob -> model, mob -> babyModel, 0.5f, 1.0f);
    }
}

