/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.common.entity.entity.water.EntitySturgeon;

public class SturgeonModel
extends TDEEntityModel<EntitySturgeon> {
    private static final String ID = "sturgeon";
    private static final ResourceLocation TEXTURE_MALE = SturgeonModel.textureLocation("sturgeon", "male.png");
    private static final ResourceLocation TEXTURE_FEMALE = SturgeonModel.textureLocation("sturgeon", "female.png");
    private static final ResourceLocation TEXTURE_BABY = SturgeonModel.textureLocation("sturgeon", "baby.png");

    public SturgeonModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
    }

    public void animate(Animator animator, EntitySturgeon entity, EntityRenderData renderData) {
        Animation animation = animator.getAnimation("animation.model.swim");
        if (!entity.m_20069_()) {
            animation = animator.getAnimation("animation.model.land");
        }
        if (entity.actionController.is(new ActionState[]{entity.actionAttack, entity.actionEat})) {
            animation = animator.getAnimation("animation.model.attack");
        }
        float bodyRotDeviation = ((Double)entity.bodyRotDeviation.get(renderData.partialTick)).floatValue();
        float bellyScale = ((Double)entity.clientPregnancyScale.get(renderData.partialTick)).floatValue();
        animator.getTransform(ID).setCustomRotation(this.clamp(renderData.entityPitch, -90.0f, 90.0f), 0.0f, 0.0f);
        if (!entity.m_6162_() && entity.actionController.is(entity.actionDig)) {
            animation = animator.getAnimation("animation.model.dig");
        }
        animator.getTransform("belly").setCustomPosition(0.0f, (1.0f - bellyScale) * 12.0f, 0.0f);
        animator.getTransform("belly").setCustomScale(1.0f, bellyScale, 1.0f);
        animator.getTransform("tail1").setCustomRotation(0.0f, -bodyRotDeviation * 2.0f, 0.0f);
        animator.getTransform("tail2").setCustomRotation(0.0f, -bodyRotDeviation * 3.0f, 0.0f);
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.1), 1.0, 1);
        if (entity.actionController.is(entity.actionEat)) {
            this.renderFoodParticles(entity, this, renderData, "head");
        }
    }

    public ResourceLocation getTexture(EntitySturgeon entity) {
        if (entity.m_6162_()) {
            return TEXTURE_BABY;
        }
        switch (entity.getGender()) {
            case MALE: {
                return TEXTURE_MALE;
            }
            case FEMALE: {
                return TEXTURE_FEMALE;
            }
        }
        return TEXTURE_MALE;
    }

    public static TDELivingRenderer<EntitySturgeon> createRenderer(EntityRendererProvider.Context context) {
        SturgeonModel model = new SturgeonModel(SturgeonModel.modelLocation(ID, "geo.json"), SturgeonModel.animationsLocation(ID, "animation.json"));
        SturgeonModel babyModel = new SturgeonModel(SturgeonModel.modelLocation(ID, "geo_baby.json"), SturgeonModel.animationsLocation(ID, "animation_baby.json"));
        return TDELivingRenderer.createRendererGendered(context, mob -> model, mob -> babyModel, 0.3f, 1.0f);
    }
}

