/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import ru.astemir.astemirlib.client.DeferredEntityRenderer;
import ru.astemir.astemirlib.client.RenderUtils;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.animation.data.PartTransform;
import ru.astemir.astemirlib.client.bedrock.model.render.BedrockModelPart;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.xishnikus.thedawnera.client.render.entity.TDEArmorLayer;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.client.render.entity.TDESaddleLayer;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityTriceratops;

public class TriceratopsModel
extends TDEEntityModel<EntityTriceratops> {
    private static final String ID = "triceratops";
    private static final ResourceLocation TEXTURE_MALE = TriceratopsModel.textureLocation("triceratops", "male.png");
    private static final ResourceLocation TEXTURE_FEMALE = TriceratopsModel.textureLocation("triceratops", "female.png");
    private static final ResourceLocation TEXTURE_BABY = TriceratopsModel.textureLocation("triceratops", "baby.png");

    public TriceratopsModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
    }

    public void animate(Animator animator, EntityTriceratops entity, EntityRenderData entityRenderData) {
        Animation animation = animator.getAnimation("animation.model.idle");
        PartTransform headTransform = animator.getTransform("neck");
        if (this.isMoving((LivingEntity)entity, -0.05f, 0.05f, entityRenderData.partialTick)) {
            animation = animator.getAnimation("animation.model.walk");
        }
        if (this.isMoving((LivingEntity)entity, -0.75f, 0.75f, entityRenderData.partialTick)) {
            animation = animator.getAnimation("animation.model.run");
        }
        if (entity.m_20069_()) {
            animation = animator.getAnimation("animation.model.swim");
        }
        if (entity.actionController.is(entity.actionEat)) {
            animation = animator.getAnimation("animation.model.eat");
        } else if (entity.actionController.is(entity.actionScream)) {
            animation = animator.getAnimation("animation.model.scream");
        }
        if (entity.actionController.is(entity.actionAttack)) {
            animation = animator.getAnimation("animation.model.attack");
            headTransform.setCustomRotation(headTransform.getCustomRotation().interpolate(new AVector3f(0.0f, 0.0f, MathUtils.sin((float)(entityRenderData.ageInTicks / 4.0f)) * 20.0f), InterpolationType.LINEAR, entityRenderData.partialTick / 20.0f));
        } else {
            headTransform.setCustomRotation(headTransform.getCustomRotation().interpolate(AVector3f.ZERO, InterpolationType.LINEAR, entityRenderData.partialTick / 20.0f));
        }
        if (entity.actionController.is(entity.actionDown)) {
            animation = animator.getAnimation("animation.model.down");
        }
        if (entity.stateController.is(entity.actionRest)) {
            animation = animator.getAnimation("animation.model.rest");
        }
        if (entity.actionController.is(entity.actionStartSleeping)) {
            animation = animator.getAnimation("animation.model.fall_asleep");
        }
        if (entity.stateController.is(entity.actionSleep)) {
            animation = animator.getAnimation("animation.model.sleep");
        }
        if (entity.actionController.is(entity.actionWakeUp)) {
            animation = animator.getAnimation("animation.model.wake_up");
        }
        if (entity.actionController.is(entity.actionUp)) {
            animation = animator.getAnimation("animation.model.up");
        }
        float bodyRotDeviation = ((Double)entity.bodyRotDeviation.get(entityRenderData.partialTick)).floatValue();
        animator.getTransform("neck").setLookAt(bodyRotDeviation / 4.0f, 0.0f);
        animator.getTransform("head").setLookAt(bodyRotDeviation / 2.0f + entityRenderData.entityYaw, entityRenderData.entityPitch);
        animator.getTransform("tail1").setLookAt(-bodyRotDeviation * 2.0f, 0.0f);
        animator.getTransform("tail2").setLookAt(-bodyRotDeviation, 0.0f);
        if (!entity.m_6162_()) {
            BedrockModelPart reins = this.getPart("reins");
            if (entity.m_6688_() != null) {
                reins.f_104207_ = true;
                float xRot = MathUtils.clamp((float)(entity.m_6688_().m_146909_() - 20.0f), (float)-5.0f, (float)10.0f);
                animator.getTransform("reins").setLookAt(0.0f, xRot / 2.0f);
                animator.getTransform("reins1").setCustomRotation(0.0f, 0.0f, xRot * 2.0f);
                animator.getTransform("reins2").setCustomRotation(0.0f, 0.0f, -xRot * 2.0f);
            } else {
                reins.f_104207_ = false;
            }
        }
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.1f), 1.0, 1);
        if (entity.actionController.is(entity.actionEat) && entity.actionController.getTicks() > 5) {
            this.renderFoodParticles(entity, this, entityRenderData, new AVector3f(0.0, -0.5, -0.8), new AVector3f(0.4f, 0.5f, 0.4f), 3, "head");
        }
    }

    @Override
    public void renderPassenger(EntityTriceratops entity, LivingEntity passenger) {
        int i = entity.m_20197_().indexOf(passenger);
        PoseStack poseStack = RenderUtils.fromPose((PoseStack.Pose)this.getPart("body").getLastPose());
        DeferredEntityRenderer.renderDeferred((UUID)passenger.m_20148_(), (PoseStack)poseStack, (AVector3f)new AVector3f(0.0f, 0.675f, -1.25f + (float)i * 0.825f), (float)0.0f);
    }

    public ResourceLocation getTexture(EntityTriceratops entity) {
        if (entity.m_6162_()) {
            return TEXTURE_BABY;
        }
        switch (entity.getGender()) {
            case MALE: {
                return TEXTURE_MALE;
            }
            case FEMALE: {
                return TEXTURE_FEMALE;
            }
        }
        return TEXTURE_MALE;
    }

    public static TDELivingRenderer<EntityTriceratops> createRenderer(EntityRendererProvider.Context context) {
        TriceratopsModel model = new TriceratopsModel(TriceratopsModel.modelLocation(ID, "geo.json"), TriceratopsModel.animationsLocation(ID, "animation.json"));
        model.addLayer(new TDEArmorLayer(model, TriceratopsModel.textureLocation(ID, "armor_0.png")));
        model.addLayer(new TDESaddleLayer(model, TriceratopsModel.textureLocation(ID, "saddle_0.png")));
        TriceratopsModel babyModel = new TriceratopsModel(TriceratopsModel.modelLocation(ID, "geo_baby.json"), TriceratopsModel.animationsLocation(ID, "animation_baby.json"));
        return TDELivingRenderer.createRendererGendered(context, mob -> model, mob -> babyModel, 1.5f, 1.0f);
    }
}

