/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import ru.astemir.astemirlib.client.DeferredEntityRenderer;
import ru.astemir.astemirlib.client.RenderUtils;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.model.render.BedrockModelPart;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.xishnikus.thedawnera.client.render.entity.TDEArmorLayer;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.client.render.entity.TDESaddleLayer;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityTyrannosaurus;

public class TyrannosaurusModel
extends TDEEntityModel<EntityTyrannosaurus> {
    private static final String ID = "tyrannosaurus";
    private static final ResourceLocation TEXTURE_MALE = TyrannosaurusModel.textureLocation("tyrannosaurus", "male.png");
    private static final ResourceLocation TEXTURE_FEMALE = TyrannosaurusModel.textureLocation("tyrannosaurus", "female.png");
    private static final ResourceLocation TEXTURE_BABY = TyrannosaurusModel.textureLocation("tyrannosaurus", "baby.png");

    public TyrannosaurusModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
    }

    public void animate(Animator animator, EntityTyrannosaurus entity, EntityRenderData entityRenderData) {
        Animation animation = animator.getAnimation("animation.model.idle");
        if (this.isMoving((LivingEntity)entity, -0.01f, 0.01f, entityRenderData.partialTick)) {
            animation = animator.getAnimation("animation.model.walk");
        }
        if (this.isMoving((LivingEntity)entity, -0.5f, 0.5f, entityRenderData.partialTick) && !entity.m_20069_()) {
            animation = animator.getAnimation("animation.model.run");
        }
        if (entity.m_9236_().m_6425_(entity.m_20183_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_)) {
            animation = animator.getAnimation("animation.model.swim");
        }
        if (entity.actionController.is(entity.actionEat)) {
            animation = animator.getAnimation("animation.model.eat");
        } else if (entity.actionController.is(entity.actionRoar)) {
            animation = animator.getAnimation("animation.model.roar");
            entity.clientNeckRot.setTo((Object)((double)MathUtils.sin((float)(entityRenderData.ageInTicks / 4.0f)) * 45.0));
        } else {
            entity.clientNeckRot.setTo((Object)0.0);
        }
        if (entity.actionController.is(entity.actionAttack1)) {
            animation = animator.getAnimation("animation.model.attack1");
        }
        if (entity.actionController.is(entity.actionAttack2)) {
            animation = animator.getAnimation("animation.model.attack2");
        }
        if (entity.actionController.is(entity.actionAttackRam)) {
            animation = animator.getAnimation("animation.model.attack3");
        }
        if (entity.actionController.is(entity.actionAttackGround)) {
            animation = animator.getAnimation("animation.model.attack4");
        }
        if (entity.actionController.is(entity.actionSniff)) {
            animation = animator.getAnimation("animation.model.sniff");
        }
        if (entity.actionController.is(entity.actionDown)) {
            animation = animator.getAnimation("animation.model.down");
        }
        if (entity.stateController.is(entity.actionRest)) {
            animation = animator.getAnimation("animation.model.rest");
        }
        if (entity.actionController.is(entity.actionStartSleeping)) {
            animation = animator.getAnimation("animation.model.fall_asleep");
        }
        if (entity.stateController.is(entity.actionSleep)) {
            animation = animator.getAnimation("animation.model.sleep");
        }
        if (entity.actionController.is(entity.actionWakeUp)) {
            animation = animator.getAnimation("animation.model.wake_up");
        }
        if (entity.actionController.is(entity.actionUp)) {
            animation = animator.getAnimation("animation.model.up");
        }
        float bodyRotDeviation = ((Double)entity.bodyRotDeviation.get(entityRenderData.partialTick)).floatValue();
        float clientNeckRot = bodyRotDeviation * 2.0f + ((Double)entity.clientNeckRot.get(entityRenderData.partialTick)).floatValue();
        animator.getTransform("neck").setLookAt(this.clamp(entityRenderData.entityYaw + clientNeckRot, -60.0f, 60.0f), this.clamp(entityRenderData.entityPitch, -20.0f, 20.0f));
        animator.getTransform("tail1").setLookAt(-bodyRotDeviation * 2.0f, 0.0f);
        animator.getTransform("tail2").setLookAt(-bodyRotDeviation, 0.0f);
        if (!entity.m_6162_()) {
            BedrockModelPart reins = this.getPart("reins");
            if (entity.m_6688_() != null) {
                reins.f_104207_ = true;
                float xRot = MathUtils.clamp((float)(entity.m_6688_().m_146909_() - 20.0f), (float)-5.0f, (float)10.0f);
                animator.getTransform("reins").setLookAt(0.0f, xRot / 2.0f);
                animator.getTransform("reins1").setCustomRotation(0.0f, 0.0f, xRot * 2.0f);
                animator.getTransform("reins2").setCustomRotation(0.0f, 0.0f, -xRot * 2.0f);
            } else {
                reins.f_104207_ = false;
            }
        }
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.15f), 1.0, 1);
        this.renderRoarParticles(entity, entityRenderData);
        if (entity.actionController.is(entity.actionEat) && entity.actionController.getTicks() > 30 && entity.actionController.getTicks() < 50 && entity.getLastEatenFood() != null) {
            if (entity.m_6162_()) {
                this.renderFoodParticles(entity, this, entityRenderData, new AVector3f(0.0f, 0.0f, -0.35f), new AVector3f(0.4f, 0.35f, 0.4f), 5, "head");
            } else {
                this.renderFoodParticles(entity, this, entityRenderData, new AVector3f(0.0f, 0.0f, -1.0f), new AVector3f(0.8f, 0.7f, 0.8f), 3, "head");
            }
        }
    }

    public void renderRoarParticles(EntityTyrannosaurus entity, EntityRenderData entityRenderData) {
        if (entity.actionController.is(entity.actionRoar) && !entity.m_6162_() && entity.actionController.getTicks() > 10 && entity.actionController.getTicks() < 60) {
            if (entity.actionController.getTicks() % 2 == 0) {
                this.renderSpitParticles((LivingEntity)entity, this, entityRenderData, "head");
            }
            this.renderRoarParticles((LivingEntity)entity, this, entityRenderData, "head", 0.5f, 0.5f, 3);
        }
    }

    @Override
    public void renderPassenger(EntityTyrannosaurus entity, LivingEntity passenger) {
        PoseStack poseStack = RenderUtils.fromPose((PoseStack.Pose)this.getPart("body").getLastPose());
        int i = entity.m_20197_().indexOf(passenger);
        DeferredEntityRenderer.renderDeferred((UUID)passenger.m_20148_(), (PoseStack)poseStack, (AVector3f)new AVector3f(0.0f, 0.3f, -0.75f + (float)i * 1.3f), (float)0.0f);
    }

    public ResourceLocation getTexture(EntityTyrannosaurus entity) {
        if (entity.m_6162_()) {
            return TEXTURE_BABY;
        }
        switch (entity.getGender()) {
            case MALE: {
                return TEXTURE_MALE;
            }
            case FEMALE: {
                return TEXTURE_FEMALE;
            }
        }
        return TEXTURE_MALE;
    }

    public static TDELivingRenderer<EntityTyrannosaurus> createRenderer(EntityRendererProvider.Context context) {
        TyrannosaurusModel model = new TyrannosaurusModel(TyrannosaurusModel.modelLocation(ID, "geo.json"), TyrannosaurusModel.animationsLocation(ID, "animation.json"));
        model.addLayer(new TDEArmorLayer(model, TyrannosaurusModel.textureLocation(ID, "armor_0.png")));
        model.addLayer(new TDESaddleLayer(model, TyrannosaurusModel.textureLocation(ID, "saddle_0.png")));
        TyrannosaurusModel babyModel = new TyrannosaurusModel(TyrannosaurusModel.modelLocation(ID, "geo_baby.json"), TyrannosaurusModel.animationsLocation(ID, "animation_baby.json"));
        return TDELivingRenderer.createRendererGendered(context, mob -> model, mob -> babyModel, 2.0f, 1.0f);
    }
}

