/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.client.render.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import ru.astemir.astemirlib.client.TimeUtil;
import ru.astemir.astemirlib.client.bedrock.animation.Animated;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.animation.data.PartTransform;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.xishnikus.thedawnera.client.render.entity.TDEEntityModel;
import ru.xishnikus.thedawnera.client.render.entity.TDELivingRenderer;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityWorm;

public class WormModel
extends TDEEntityModel<EntityWorm> {
    private static final String ID = "worm";
    private static final ResourceLocation TEXTURE = WormModel.textureLocation("worm", "worm.png");

    public WormModel(ResourceLocation model, ResourceLocation animations) {
        super(model, animations);
    }

    public void animate(Animator animator, EntityWorm entity, EntityRenderData renderData) {
        Animation animation = animator.getAnimation("animation.model.idle");
        if (this.isMoving((LivingEntity)entity, -0.01f, 0.01f, renderData.partialTick)) {
            animation = animator.getAnimation("animation.model.walk");
        }
        PartTransform worm = animator.getTransform(ID);
        if (!Minecraft.m_91087_().m_91104_()) {
            if (entity.actionController.is(entity.actionDig)) {
                float animSpeed = 0.85f;
                worm.setCustomRotation(worm.getCustomRotation().interpolate(new AVector3f(90.0f, 0.0f, 0.0f), InterpolationType.LINEAR, (float)TimeUtil.getDeltaGlfw() * 4.0f * animSpeed));
                worm.setCustomPosition(worm.getCustomPosition().interpolate(new AVector3f(0.0f, -8.0f, 0.0f), InterpolationType.LINEAR, (float)TimeUtil.getDeltaGlfw() * animSpeed));
            } else {
                worm.setCustomRotation(0.0f, 0.0f, 0.0f);
                worm.setCustomPosition(0.0f, 0.0f, 0.0f);
            }
        }
        animator.setAnimation(animation, AnimationBlending.create((InterpolationType)InterpolationType.CATMULLROM, (EasingType)EasingType.NONE, (double)0.3), 1.0, 1);
    }

    public void renderFinal(BedrockModel model, EntityWorm object, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Color color) {
        float f = object.m_6134_();
        poseStack.m_85841_(f, f, f);
        super.renderFinal(model, (Animated)object, poseStack, bufferSource, packedLight, packedOverlay, color);
    }

    public ResourceLocation getTexture(EntityWorm object) {
        return TEXTURE;
    }

    public static TDELivingRenderer<EntityWorm> createRenderer(EntityRendererProvider.Context context) {
        WormModel model = new WormModel(WormModel.modelLocation(ID, "geo.json"), WormModel.animationsLocation(ID, "animation.json"));
        return TDELivingRenderer.createDefaultRenderer(context, mob -> model, 0.2f, 0.5f);
    }
}

