/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import ru.astemir.astemirlib.common.handler.LevelEventMap;
import ru.astemir.astemirlib.common.handler.ServerLevelEventHandler;
import ru.astemir.astemirlib.common.network.PacketArgument;
import ru.xishnikus.thedawnera.common.TDELevelEvents;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.input.InputKey;
import ru.xishnikus.thedawnera.common.entity.input.KeyInputMob;

public class TDEServerProxy
implements ServerLevelEventHandler {
    private static final LevelEventMap SERVER_EVENTS = LevelEventMap.create().registerEvent(TDELevelEvents.EVENT_MOB_STEP, (pos, level, args) -> {
        int id = args[0].asInt();
        float power = args[1].asFloat();
        Entity entity = level.m_6815_(id);
        if (entity != null && entity instanceof BaseAnimal) {
            BaseAnimal baseAnimal = (BaseAnimal)entity;
            baseAnimal.onServerMobStep(power);
        }
    }).registerEvent(TDELevelEvents.EVENT_MOB_INPUT, (pos, level, args) -> {
        KeyInputMob keyInputMob;
        InputKey key;
        int id = args[0].asInt();
        Entity entity = level.m_6815_(id);
        if (entity != null && entity instanceof KeyInputMob && (key = (keyInputMob = (KeyInputMob)entity).getInputMap().getKeyById(args[1].asInt())) != null) {
            key.setPressed(args[2].asBoolean());
            keyInputMob.onInputHandle(key);
        }
    }).registerEvent(TDELevelEvents.EVENT_MOB_UPDATE_ORDERS, (pos, level, args) -> {
        int playerId = args[0].asInt();
        int id = args[1].asInt();
        Entity player = level.m_6815_(playerId);
        Entity entity = level.m_6815_(id);
        if (entity != null) {
            int dataId = args[2].asInt();
            if (entity instanceof BaseAnimal) {
                BaseAnimal baseAnimal = (BaseAnimal)entity;
                MobOrder mobAction = MobOrder.fromId(dataId);
                if (mobAction.isBehaviour()) {
                    baseAnimal.setBehaviourType(mobAction.behaviour());
                } else if (mobAction.isMovement()) {
                    baseAnimal.setMovementOrderType(mobAction.movementOrder());
                } else if (mobAction.isEating()) {
                    baseAnimal.setFoodOrderType(mobAction.foodOrder());
                } else if (mobAction.isAccessibility()) {
                    baseAnimal.setAccessibility(mobAction.accessibility());
                } else if (mobAction.isAction()) {
                    mobAction.action().getAction().accept((Player)player, baseAnimal);
                }
                if (mobAction.isSpecific()) {
                    baseAnimal.setSpecificOrderType(mobAction.specific());
                }
            }
        }
    });

    public void onHandleEvent(ServerLevel serverLevel, BlockPos blockPos, int id, PacketArgument[] packetArguments) {
        SERVER_EVENTS.handleEvent(id, (Level)serverLevel, blockPos, packetArguments);
    }
}

