/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.advancement;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootContext;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;
import ru.xishnikus.thedawnera.common.utils.TDEUtils;

public class CriteriaTriggerNameMob
extends SimpleCriterionTrigger<Instance> {
    static final ResourceLocation ID = new ResourceLocation("dawnera", "name_mob");

    protected Instance createInstance(JsonObject jsonObject, ContextAwarePredicate contextAwarePredicate, DeserializationContext deserializationContext) {
        return new Instance(contextAwarePredicate, EntityPredicate.m_285855_((JsonObject)jsonObject, (String)"entity", (DeserializationContext)deserializationContext), (List)TDEJsonUtils.GSON.fromJson(jsonObject.get("customName"), new TypeToken<ArrayList<String>>(){}.getType()));
    }

    public void trigger(ServerPlayer serverPlayer, Entity entity) {
        LootContext lootcontext = EntityPredicate.m_36616_((ServerPlayer)serverPlayer, (Entity)entity);
        super.m_66234_(serverPlayer, instance -> instance.matches(serverPlayer, entity, lootcontext));
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public static <T extends Entity> Instance instance(Supplier<EntityType<T>> entityType, List<String> name) {
        return new Instance(ContextAwarePredicate.f_285567_, EntityPredicate.m_285787_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_(entityType.get()).m_36662_()), name);
    }

    public static Instance instance(TagKey<EntityType<?>> tagKey, List<String> name) {
        return new Instance(ContextAwarePredicate.f_285567_, EntityPredicate.m_285787_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_204077_(tagKey).m_36662_()), name);
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private ContextAwarePredicate entityPredicate;
        private List<String> possibleNames;

        public Instance(ContextAwarePredicate contextAwarePredicate, ContextAwarePredicate entityPredicate, List<String> possibleNames) {
            super(ID, contextAwarePredicate);
            this.entityPredicate = entityPredicate;
            this.possibleNames = possibleNames;
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject jsonobject = super.m_7683_(context);
            jsonobject.add("entity", this.entityPredicate.m_286026_(context));
            jsonobject.add("customName", TDEJsonUtils.GSON.toJsonTree(this.possibleNames));
            return jsonobject;
        }

        public boolean matches(ServerPlayer player, Entity entity, LootContext lootContext) {
            if (this.entityPredicate.m_285831_(lootContext)) {
                for (String possibleName : this.possibleNames) {
                    if (!TDEUtils.isEntityNamedAs(entity, possibleName)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

