/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockShapeBuilder {
    private Map<Integer, VoxelShape> shapes = new HashMap<Integer, VoxelShape>();

    public VoxelShape getShape(int value) {
        if (this.shapes.containsKey(value)) {
            return this.shapes.get(value);
        }
        return this.first();
    }

    public VoxelShape first() {
        return this.shapes.get(1);
    }

    public Box box() {
        return new Box(this);
    }

    public Box box(double x, double y, double z) {
        return new Box(this).pos(x, y, z);
    }

    public Box box(double x, double y, double z, double width, double height, double depth) {
        return new Box(this).pos(x, y, z).size(width, height, depth);
    }

    public MultiBox multiBox() {
        return new MultiBox(this);
    }

    public static class Box
    extends ShapedBox {
        private double x;
        private double y;
        private double z;
        private double width;
        private double height;
        private double depth;
        private MultiBox multiBox;

        public Box(BlockShapeBuilder builder) {
            super(builder);
        }

        public Box(BlockShapeBuilder builder, MultiBox multiBox) {
            super(builder);
            this.multiBox = multiBox;
        }

        public Box pos(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Box size(double width, double height, double depth) {
            this.width = width;
            this.height = height;
            this.depth = depth;
            return this;
        }

        public MultiBox box() {
            this.multiBox.box();
            return this.multiBox;
        }

        public MultiBox box(double x, double y, double z) {
            this.multiBox.box(x, y, z);
            return this.multiBox;
        }

        public MultiBox box(double x, double y, double z, double width, double height, double depth) {
            this.multiBox.box(x, y, z, width, height, depth);
            return this.multiBox;
        }

        private VoxelShape shape() {
            return Block.m_49796_((double)this.x, (double)this.y, (double)this.z, (double)(this.x + this.width), (double)(this.y + this.height), (double)(this.z + this.depth));
        }

        @Override
        public BlockShapeBuilder build(int index) {
            if (this.multiBox != null) {
                return this.multiBox.build(index);
            }
            this.builder.shapes.put(index, this.shape());
            return this.builder;
        }
    }

    public static class MultiBox
    extends ShapedBox {
        private List<Box> boxes = new ArrayList<Box>();
        private Box baseBox;

        public MultiBox(BlockShapeBuilder builder) {
            super(builder);
        }

        public Box box() {
            Box box = new Box(this.builder, this);
            if (this.baseBox == null) {
                this.baseBox = box;
            } else {
                this.boxes.add(box);
            }
            return box;
        }

        public Box box(double x, double y, double z) {
            Box box = new Box(this.builder, this).pos(x, y, z);
            if (this.baseBox == null) {
                this.baseBox = box;
            } else {
                this.boxes.add(box);
            }
            return box;
        }

        public Box box(double x, double y, double z, double width, double height, double depth) {
            Box box = new Box(this.builder, this).pos(x, y, z).size(width, height, depth);
            if (this.baseBox == null) {
                this.baseBox = box;
            } else {
                this.boxes.add(box);
            }
            return box;
        }

        @Override
        public BlockShapeBuilder build(int index) {
            VoxelShape shape = this.baseBox.shape();
            for (Box box : this.boxes) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)box.shape());
            }
            this.builder.shapes.put(index, shape);
            return this.builder;
        }
    }

    public static abstract class ShapedBox {
        protected BlockShapeBuilder builder;

        public ShapedBox(BlockShapeBuilder builder) {
            this.builder = builder;
        }

        public abstract BlockShapeBuilder build(int var1);
    }
}

