/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.block.eggs;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.block.BlockShapeBuilder;
import ru.xishnikus.thedawnera.common.block.TDEBlockStateProperties;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;
import ru.xishnikus.thedawnera.common.misc.TDESoundTypes;

public class TDEBlockEgg
extends FallingBlock {
    private Supplier<? extends EntityType<? extends AgeableMob>> entityType;
    private BlockShapeBuilder blockShapeBuilder;
    protected IntegerProperty propertyHatchStage;
    protected IntegerProperty propertyEggCount;
    private int maxHatchLevel;
    private int maxEggs;

    public TDEBlockEgg(Supplier<? extends EntityType<? extends AgeableMob>> entityType, BlockShapeBuilder shapeBuilder, int maxHatchLevel, int maxEggs) {
        this(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_280606_().m_60978_(0.5f).m_60918_((SoundType)TDESoundTypes.EGG).m_60977_().m_60955_().m_278166_(PushReaction.DESTROY), entityType, shapeBuilder, maxHatchLevel, maxEggs);
    }

    public TDEBlockEgg(BlockBehaviour.Properties properties, Supplier<? extends EntityType<? extends AgeableMob>> entityType, BlockShapeBuilder shapeBuilder, int maxHatchLevel, int maxEggs) {
        super(properties);
        this.entityType = entityType;
        this.blockShapeBuilder = shapeBuilder;
        this.maxHatchLevel = maxHatchLevel;
        this.maxEggs = maxEggs;
        this.propertyHatchStage = TDEBlockStateProperties.matchHatchProperty(maxHatchLevel);
        if (maxEggs > 1) {
            this.propertyEggCount = TDEBlockStateProperties.matchEggProperty(maxEggs);
        }
        this.forceRegisterState();
    }

    public void forceRegisterState() {
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.addStates((StateDefinition.Builder<Block, BlockState>)builder);
        this.f_49792_ = builder.m_61101_(Block::m_49966_, BlockState::new);
        BlockState state = (BlockState)this.f_49792_.m_61090_();
        this.setupBlockState(state);
        this.m_49959_(state);
    }

    public void setupBlockState(BlockState blockState) {
        blockState.m_61124_((Property)this.propertyHatchStage, (Comparable)Integer.valueOf(0));
        if (this.propertyEggCount != null) {
            blockState.m_61124_((Property)this.propertyEggCount, (Comparable)Integer.valueOf(1));
        }
    }

    public void addStates(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.propertyHatchStage});
        if (this.maxEggs > 1) {
            builder.m_61104_(new Property[]{this.propertyEggCount});
        }
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext collisionContext) {
        if (this.propertyEggCount != null) {
            return this.blockShapeBuilder.getShape((Integer)blockState.m_61143_((Property)this.propertyEggCount));
        }
        return this.blockShapeBuilder.first();
    }

    public void m_141947_(Level level, BlockPos pos, BlockState blockState, Entity entity) {
        if (!entity.m_20161_()) {
            this.destroyEgg(level, blockState, pos, entity, 100);
        }
        super.m_141947_(level, pos, blockState, entity);
    }

    public void m_142072_(Level level, BlockState blockState, BlockPos blockPos, Entity entity, float distance) {
        if (!(entity instanceof Zombie)) {
            this.destroyEgg(level, blockState, blockPos, entity, 3);
        }
        super.m_142072_(level, blockState, blockPos, entity, distance);
    }

    private void destroyEgg(Level level, BlockState blockState, BlockPos blockPos, Entity entity, int chance) {
        if (this.canDestroyEgg(level, entity) && !level.f_46443_ && level.f_46441_.m_188503_(chance) == 0 && blockState.m_60713_((Block)this)) {
            this.decreaseEggs(level, blockPos, blockState);
        }
    }

    private boolean canDestroyEgg(Level level, Entity entity) {
        if (!(entity instanceof Turtle || entity instanceof Bat || entity.m_6095_().equals(this.entityType.get()))) {
            if (!(entity instanceof LivingEntity)) {
                return false;
            }
            return entity instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity);
        }
        return false;
    }

    private void decreaseEggs(Level level, BlockPos blockPos, BlockState blockState) {
        int i;
        int n = i = this.propertyEggCount != null ? (Integer)blockState.m_61143_((Property)this.propertyEggCount) : 1;
        if (i <= 1) {
            level.m_5594_(null, blockPos, (SoundEvent)TDESoundEvents.EGG_BREAK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
            level.m_46961_(blockPos, false);
        } else {
            level.m_5594_(null, blockPos, (SoundEvent)TDESoundEvents.EGG_HIT.get(), SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)this.propertyEggCount, (Comparable)Integer.valueOf(i - 1)), 2);
            level.m_220407_(GameEvent.f_157794_, blockPos, GameEvent.Context.m_223722_((BlockState)blockState));
            level.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
    }

    public void m_213898_(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        this.m_213897_(blockState, level, blockPos, randomSource);
        if (RandomUtils.doWithChance((RandomSource)randomSource, (float)25.0f)) {
            int hatchStage = (Integer)blockState.m_61143_((Property)this.propertyHatchStage);
            if (hatchStage < this.maxHatchLevel) {
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)this.propertyHatchStage, (Comparable)Integer.valueOf(hatchStage + 1)), this.maxHatchLevel);
                level.m_5594_(null, blockPos, (SoundEvent)TDESoundEvents.EGG_HIT.get(), SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
            } else {
                level.m_7471_(blockPos, false);
                level.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockState));
                int eggCount = this.propertyEggCount != null ? (Integer)blockState.m_61143_((Property)this.propertyEggCount) : 1;
                for (int i = 0; i < eggCount; ++i) {
                    AgeableMob mob = (AgeableMob)this.entityType.get().m_20615_((Level)level);
                    if (mob == null) continue;
                    mob.m_146762_(-24000);
                    mob.m_7678_((double)blockPos.m_123341_() + 0.3 + (double)RandomUtils.randomFloat((float)-0.25f, (float)0.25f), (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.3 + (double)RandomUtils.randomFloat((float)-0.25f, (float)0.25f), 0.0f, 0.0f);
                    level.m_7967_((Entity)mob);
                }
                level.m_5594_(null, blockPos, (SoundEvent)TDESoundEvents.EGG_BREAK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
            }
        }
    }

    public void m_214162_(BlockState p_221129_, Level p_221130_, BlockPos p_221131_, RandomSource p_221132_) {
    }

    public void m_6807_(BlockState p_57814_, Level level, BlockPos pos, BlockState p_57816_, boolean p_57818_) {
        super.m_6807_(p_57814_, level, pos, p_57814_, p_57818_);
        if (!level.f_46443_) {
            level.m_46796_(2005, pos, 0);
        }
    }

    public void m_48792_(Level level, BlockPos blockPos, BlockState blockState, BlockState stateFallOn, FallingBlockEntity fallingBlockEntity) {
        if (level.f_46441_.m_188503_(2) == 0) {
            this.decreaseEggs(level, blockPos, blockState);
        }
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext placeContext) {
        int eggsCount = this.propertyEggCount != null ? (Integer)blockState.m_61143_((Property)this.propertyEggCount) : 1;
        return !placeContext.m_7078_() && placeContext.m_43722_().m_150930_(this.m_5456_()) && eggsCount < this.maxEggs ? true : super.m_6864_(blockState, placeContext);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_());
        if (blockState.m_60713_((Block)this) && this.propertyEggCount != null) {
            return (BlockState)blockState.m_61124_((Property)this.propertyEggCount, (Comparable)Integer.valueOf(Math.min(this.maxEggs, (Integer)blockState.m_61143_((Property)this.propertyEggCount) + 1)));
        }
        return super.m_5573_(context);
    }

    public int getMaxHatchLevel() {
        return this.maxHatchLevel;
    }

    public int getMaxEggs() {
        return this.maxEggs;
    }

    public IntegerProperty getPropertyHatchStage() {
        return this.propertyHatchStage;
    }

    public IntegerProperty getPropertyEggCount() {
        return this.propertyEggCount;
    }
}

