/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal;

import java.util.function.BooleanSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.GoalTrigger;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;

public abstract class CustomGoal<T extends BaseAnimal>
extends Goal {
    protected final T mob;
    private BooleanSupplier canUseCondition;
    private BooleanSupplier canContinueUseCondition;
    private boolean shouldCanBeUsedToContinue = false;

    public CustomGoal(T mob) {
        this.mob = mob;
    }

    public boolean tryToTrigger(GoalTrigger trigger, Runnable onSuccess) {
        if (trigger != null) {
            onSuccess.run();
            return true;
        }
        return false;
    }

    public boolean isCanBeUsed() {
        if (this.canUseCondition == null) {
            return true;
        }
        return this.canUseCondition.getAsBoolean();
    }

    public boolean isCanBeContinuedToUse() {
        if (this.isShouldCanBeUsedToContinue() && !this.isCanBeUsed()) {
            return false;
        }
        if (this.canContinueUseCondition == null) {
            return true;
        }
        return this.canContinueUseCondition.getAsBoolean();
    }

    public boolean isShouldCanBeUsedToContinue() {
        return this.shouldCanBeUsedToContinue;
    }

    public void setCanUseCondition(BooleanSupplier condition) {
        this.canUseCondition = condition;
    }

    public void setCanContinueUseCondition(BooleanSupplier condition) {
        this.canContinueUseCondition = condition;
    }

    public void setShouldCanBeUsedToContinue(boolean shouldCanBeUsedToContinue) {
        this.shouldCanBeUsedToContinue = shouldCanBeUsedToContinue;
    }

    public T getMob() {
        return this.mob;
    }
}

