/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.scores.Team;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;

public class CustomTargetGoal<T extends BaseAnimal>
extends CustomGoal<T> {
    protected boolean mustSee;
    private boolean mustReach;
    private int reachCache;
    private int reachCacheTime;
    private int unseenTicks;
    @Nullable
    protected LivingEntity targetMob;
    protected int unseenMemoryTicks = 200;
    private Predicate<Entity> canTargetMobCondition;

    public CustomTargetGoal(T mob, boolean mustSee) {
        super(mob);
        this.mustSee = mustSee;
        this.mustReach = false;
    }

    public CustomTargetGoal(T mob, boolean mustSee, boolean mustReach) {
        super(mob);
        this.mustSee = mustSee;
        this.mustReach = mustReach;
    }

    public boolean m_8036_() {
        return this.isCanBeUsed();
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            livingentity = this.targetMob;
        }
        if (livingentity == null) {
            return false;
        }
        if (!this.mob.m_6779_(livingentity)) {
            return false;
        }
        Team team = this.mob.m_5647_();
        Team team1 = livingentity.m_5647_();
        if (team != null && team1 == team) {
            return false;
        }
        double d0 = this.getFollowDistance();
        if (this.mob.m_20280_((Entity)livingentity) > d0 * d0) {
            return false;
        }
        if (this.mustSee) {
            if (this.mob.m_21574_().m_148306_((Entity)livingentity)) {
                this.unseenTicks = 0;
            } else if (++this.unseenTicks > CustomTargetGoal.m_186073_((int)this.unseenMemoryTicks)) {
                return false;
            }
        }
        this.mob.m_6710_(livingentity);
        return true;
    }

    public void m_8056_() {
        this.reachCache = 0;
        this.reachCacheTime = 0;
        this.unseenTicks = 0;
    }

    public void m_8041_() {
        this.mob.m_6710_(null);
        this.targetMob = null;
    }

    protected boolean canAttack(@Nullable LivingEntity target, TargetingConditions targetingConditions) {
        if (target == null) {
            return false;
        }
        if (!targetingConditions.m_26885_((LivingEntity)this.mob, target)) {
            return false;
        }
        if (!this.mob.m_21444_(target.m_20183_())) {
            return false;
        }
        if (this.canTargetMobCondition != null && !this.canTargetMobCondition.test((Entity)target)) {
            return false;
        }
        if (this.mustReach) {
            if (--this.reachCacheTime <= 0) {
                this.reachCache = 0;
            }
            if (this.reachCache == 0) {
                int n = this.reachCache = this.canReach(target) ? 1 : 2;
            }
            if (this.reachCache == 2) {
                return false;
            }
        }
        return true;
    }

    protected boolean canReach(LivingEntity target) {
        int j;
        this.reachCacheTime = CustomTargetGoal.m_186073_((int)(10 + this.mob.m_217043_().m_188503_(5)));
        Path path = this.mob.m_21573_().m_6570_((Entity)target, 0);
        if (path == null) {
            return false;
        }
        Node node = path.m_77395_();
        if (node == null) {
            return false;
        }
        int i = node.f_77271_ - target.m_146903_();
        return (double)(i * i + (j = node.f_77273_ - target.m_146907_()) * j) <= 2.25;
    }

    public void setCanTargetCondition(Predicate<Entity> condition) {
        this.canTargetMobCondition = condition;
    }

    public void setMustSee(boolean mustSee) {
        this.mustSee = mustSee;
    }

    public void setMustReach(boolean mustReach) {
        this.mustReach = mustReach;
    }

    public void setUnseenMemoryTicks(int unseenMemoryTicks) {
        this.unseenMemoryTicks = unseenMemoryTicks;
    }

    @Nullable
    public LivingEntity getTargetMob() {
        return this.targetMob;
    }

    protected double getFollowDistance() {
        return this.mob.m_21133_(Attributes.f_22277_);
    }
}

