/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobAction;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobCondition;

public interface GoalTrigger {

    public static interface ForMobBlockPos
    extends GoalTrigger {
        public void activate(Mob var1, BlockPos var2);

        public static ForMobBlockPos fromJson(JsonObject json, String name) {
            JsonObject jsonObject = json.getAsJsonObject(name);
            Predicate<Entity> predicate = MobCondition.parsePredicate(Entity.class, jsonObject, "Conditions");
            List<MobAction> actions = MobAction.parseListFromJson(jsonObject, "Actions");
            return (mob, blockPos) -> {
                if (predicate.test((Entity)mob)) {
                    for (MobAction action : actions) {
                        action.run(mob, blockPos);
                    }
                }
            };
        }
    }

    public static interface ForMobTargetDistance
    extends GoalTrigger {
        public void activate(Mob var1, LivingEntity var2, double var3);

        public static ForMobTargetDistance fromJson(JsonObject json, String name) {
            JsonObject jsonObject = json.getAsJsonObject(name);
            Predicate<Entity> condition = MobCondition.parsePredicate(Entity.class, jsonObject, "Conditions");
            Predicate<Entity> targetCondition = MobCondition.parsePredicate(Entity.class, jsonObject, "TargetCondition");
            List<MobAction> actions = MobAction.parseListFromJson(jsonObject, "Actions");
            return (mob, target, distance) -> {
                if (condition.test((Entity)mob) && targetCondition.test((Entity)target)) {
                    for (MobAction action : actions) {
                        action.run(mob, target, distance);
                    }
                }
            };
        }
    }

    public static interface ForMobTarget
    extends GoalTrigger {
        public void activate(Mob var1, Entity var2);

        public static ForMobTarget fromJson(JsonObject json, String name) {
            JsonObject jsonObject = json.getAsJsonObject(name);
            Predicate<Entity> condition = MobCondition.parsePredicate(Entity.class, jsonObject, "Conditions");
            Predicate<Entity> targetCondition = MobCondition.parsePredicate(Entity.class, jsonObject, "TargetCondition");
            List<MobAction> actions = MobAction.parseListFromJson(jsonObject, "Actions");
            return (mob, target) -> {
                if (condition.test((Entity)mob) && targetCondition.test(target)) {
                    for (MobAction action : actions) {
                        action.run(mob, target);
                    }
                }
            };
        }
    }

    public static interface ForMob
    extends GoalTrigger {
        public void activate(Mob var1);

        public static ForMob fromJson(JsonObject json, String name) {
            JsonObject jsonObject = json.getAsJsonObject(name);
            Predicate<Entity> condition = MobCondition.parsePredicate(Entity.class, jsonObject, "Conditions");
            List<MobAction> actions = MobAction.parseListFromJson(jsonObject, "Actions");
            return mob -> {
                if (condition.test((Entity)mob)) {
                    for (MobAction action : actions) {
                        action.run(mob);
                    }
                }
            };
        }
    }
}

