/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.attack;

import com.google.gson.JsonObject;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.GoalTrigger;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalMeleeAttack<T extends BaseAnimal>
extends CustomGoal<T> {
    private Path path;
    protected final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private double meleeRangeModifier = 2.0;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private int failedPathFindingPenalty;
    private long lastCanUseCheck;
    private boolean canPenalize = false;
    private GoalTrigger.ForMobTargetDistance triggerAttack;
    private GoalTrigger.ForMobTarget triggerStartAggression;
    private GoalTrigger.ForMobTarget triggerStopAggression;

    public GoalMeleeAttack(T mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        super(mob);
        this.speedModifier = speedModifier;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.m_6688_() != null) {
            return false;
        }
        long i = this.mob.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.mob.m_6779_(livingentity)) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.mob.getReachDistanceTo((Entity)livingentity, this.meleeRangeModifier) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.mob.m_6779_(livingentity)) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(livingentity.m_20183_())) {
            return false;
        }
        if (this.mob.m_6688_() != null) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.tryMoveTo(this.path);
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
        this.tryToTrigger(this.triggerStartAggression, () -> this.triggerStartAggression.activate((Mob)this.mob, (Entity)this.mob.m_5448_()));
    }

    public void m_8041_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingEntity)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
        this.tryToTrigger(this.triggerStopAggression, () -> this.triggerStopAggression.activate((Mob)this.mob, (Entity)this.mob.m_5448_()));
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity != null) {
            boolean canSee = this.mob.m_21574_().m_148306_((Entity)livingEntity);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            this.mob.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
            double d0 = this.mob.m_262793_(livingEntity);
            if ((this.followingTargetEvenIfNotSeen || canSee) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingEntity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = livingEntity.m_20185_();
                this.pathedTargetY = livingEntity.m_20186_();
                this.pathedTargetZ = livingEntity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingEntity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.tryMoveTo(this.mob.m_21573_().m_6570_((Entity)livingEntity, 1))) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(livingEntity, d0);
        }
    }

    protected boolean tryMoveTo(Path path) {
        return this.mob.m_21573_().m_26536_(path, this.speedModifier);
    }

    protected boolean checkAndPerformAttack(LivingEntity livingEntity, double distance) {
        double d0 = this.mob.getReachDistanceTo((Entity)livingEntity, this.meleeRangeModifier);
        if (distance <= d0 && this.ticksUntilNextAttack <= 0) {
            this.ticksUntilNextAttack = this.m_183277_(20);
            if (!this.tryToTrigger(this.triggerAttack, () -> this.triggerAttack.activate((Mob)this.mob, livingEntity, distance))) {
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_7327_((Entity)livingEntity);
            }
            return true;
        }
        return false;
    }

    public boolean m_183429_() {
        return true;
    }

    public void setMeleeRangeModifier(double meleeRangeModifier) {
        this.meleeRangeModifier = meleeRangeModifier;
    }

    public void setTriggerAttack(GoalTrigger.ForMobTargetDistance triggerAttack) {
        this.triggerAttack = triggerAttack;
    }

    public void setTriggerStartAggression(GoalTrigger.ForMobTarget triggerStartAggression) {
        this.triggerStartAggression = triggerStartAggression;
    }

    public void setTriggerStopAggression(GoalTrigger.ForMobTarget triggerStopAggression) {
        this.triggerStopAggression = triggerStopAggression;
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="Speed")
        protected NumberProperty speedModifier = NumberProperty.uniform(1.0);
        @JsonField(value="MeleeRange")
        protected NumberProperty meleeRange = NumberProperty.uniform(2.0);
        @JsonField(value="ShouldSeeTarget")
        protected boolean shouldSeeTarget = true;
        protected GoalTrigger.ForMobTarget startAggression;
        protected GoalTrigger.ForMobTarget stopAggression;
        protected GoalTrigger.ForMobTargetDistance performAttack;

        public CustomGoal<BaseAnimal> create(BaseAnimal animal) {
            GoalMeleeAttack<BaseAnimal> goal = new GoalMeleeAttack<BaseAnimal>(animal, this.speedModifier.getFloat(), !this.shouldSeeTarget);
            goal.setMeleeRangeModifier(this.meleeRange.getDouble());
            goal.setTriggerStartAggression(this.startAggression);
            goal.setTriggerStopAggression(this.stopAggression);
            goal.setTriggerAttack(this.performAttack);
            return goal;
        }

        @Override
        public void deserialize(JsonObject json) {
            if (json.has("StartAggression")) {
                this.startAggression = GoalTrigger.ForMobTarget.fromJson(json, "StartAggression");
            }
            if (json.has("LoseAggression")) {
                this.stopAggression = GoalTrigger.ForMobTarget.fromJson(json, "LoseAggression");
            }
            if (json.has("PerformAttack")) {
                this.performAttack = GoalTrigger.ForMobTargetDistance.fromJson(json, "PerformAttack");
            }
        }
    }
}

