/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.avoid;

import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobCondition;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalAvoidEntity<T extends BaseAnimal, K extends LivingEntity>
extends CustomGoal<T> {
    @Nullable
    protected K toAvoid;
    @Nullable
    protected Path path;
    protected final PathNavigation pathNav;
    protected final Class<K> avoidClass;
    protected final float maxDist;
    private final double walkSpeedModifier;
    private final double sprintSpeedModifier;
    protected final Predicate<LivingEntity> avoidPredicate;
    protected final Predicate<LivingEntity> predicateOnAvoidEntity;
    private final TargetingConditions avoidEntityTargeting;

    public GoalAvoidEntity(T mob, Class<K> avoidClass, Predicate<LivingEntity> avoidPredicate, float maxDist, double walkSpeedModifier, double sprintSpeedModifier, Predicate<LivingEntity> predicateOnAvoidEntity) {
        super(mob);
        this.avoidClass = avoidClass;
        this.avoidPredicate = avoidPredicate;
        this.maxDist = maxDist;
        this.walkSpeedModifier = walkSpeedModifier;
        this.sprintSpeedModifier = sprintSpeedModifier;
        this.predicateOnAvoidEntity = predicateOnAvoidEntity;
        this.pathNav = mob.m_21573_();
        this.avoidEntityTargeting = TargetingConditions.m_148352_().m_26883_((double)maxDist).m_26888_(avoidPredicate.and(predicateOnAvoidEntity));
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        this.toAvoid = this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(this.avoidClass, this.mob.m_20191_().m_82377_((double)this.maxDist, 3.0, (double)this.maxDist), p_148078_ -> true), this.avoidEntityTargeting, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
        if (this.toAvoid == null) {
            return false;
        }
        Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)this.toAvoid.m_20182_());
        if (vec3 == null) {
            return false;
        }
        if (this.toAvoid.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.toAvoid.m_20280_((Entity)this.mob)) {
            return false;
        }
        this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
        return this.path != null;
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        return !this.pathNav.m_26571_();
    }

    public void m_8056_() {
        this.pathNav.m_26536_(this.path, this.walkSpeedModifier);
    }

    public void m_8041_() {
        this.toAvoid = null;
    }

    public void m_8037_() {
        if (this.mob.m_20280_((Entity)this.toAvoid) < 49.0) {
            this.mob.m_21573_().m_26517_(this.sprintSpeedModifier);
        } else {
            this.mob.m_21573_().m_26517_(this.walkSpeedModifier);
        }
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="MaxDistance")
        private NumberProperty maxDistance = NumberProperty.uniform(10.0);
        @JsonField(value="WalkSpeed")
        private NumberProperty walkSpeedModifier = NumberProperty.uniform(1.0);
        @JsonField(value="SprintSpeed")
        private NumberProperty sprintSpeedModifier = NumberProperty.uniform(2.0);
        private Predicate<LivingEntity> targetConditions = target -> true;

        public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            return new GoalAvoidEntity<BaseAnimal, LivingEntity>(animal, LivingEntity.class, this.targetConditions, this.maxDistance.getFloat(), this.walkSpeedModifier.getDouble(), this.sprintSpeedModifier.getDouble(), EntitySelector.f_20406_::test);
        }

        @Override
        public void deserialize(JsonObject json) {
            if (json.has("TargetConditions")) {
                this.targetConditions = MobCondition.parsePredicate(LivingEntity.class, json, "TargetConditions");
            }
        }
    }
}

