/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.avoid;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalAvoidLowHealth<T extends BaseAnimal>
extends CustomGoal<T> {
    protected final PathNavigation pathNav;
    protected Path path;
    private final double walkSpeedModifier;
    private final double sprintSpeedModifier;
    protected final float maxDist;

    public GoalAvoidLowHealth(T mob, double walkSpeedModifier, double sprintSpeedModifier, float maxDist) {
        super(mob);
        this.walkSpeedModifier = walkSpeedModifier;
        this.sprintSpeedModifier = sprintSpeedModifier;
        this.maxDist = maxDist;
        this.pathNav = mob.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.isTamed()) {
            return false;
        }
        if (this.mob.m_21223_() / this.mob.m_21233_() > 0.25f || this.mob.m_21188_() == null) {
            return false;
        }
        Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)48, (int)7, (Vec3)this.mob.m_21188_().m_20182_());
        if (vec3 == null) {
            return false;
        }
        if (this.mob.m_21188_().m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.mob.m_21188_().m_20280_((Entity)this.mob)) {
            return false;
        }
        this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
        return this.path != null;
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        if (this.mob.isTamed()) {
            return false;
        }
        return !this.pathNav.m_26571_() && this.mob.m_21188_() != null;
    }

    public void m_8056_() {
        this.pathNav.m_26536_(this.path, this.walkSpeedModifier);
        this.mob.m_6710_(null);
    }

    public void m_8037_() {
        if (this.mob.m_20280_((Entity)this.mob.m_21188_()) < 49.0) {
            this.mob.m_21573_().m_26517_(this.sprintSpeedModifier);
        } else {
            this.mob.m_21573_().m_26517_(this.walkSpeedModifier);
        }
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="MaxDistance")
        private NumberProperty maxDistance = NumberProperty.uniform(10.0);
        @JsonField(value="WalkSpeed")
        private NumberProperty walkSpeedModifier = NumberProperty.uniform(1.0);
        @JsonField(value="SprintSpeed")
        private NumberProperty sprintSpeedModifier = NumberProperty.uniform(2.0);

        public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            return new GoalAvoidLowHealth<BaseAnimal>(animal, this.walkSpeedModifier.getDouble(), this.sprintSpeedModifier.getDouble(), this.maxDistance.getFloat());
        }
    }
}

