/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.avoid;

import com.google.gson.JsonObject;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.GoalTrigger;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalPanicOfDamage<T extends BaseAnimal>
extends CustomGoal<T> {
    protected final double speedModifier;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected boolean isRunning;
    private GoalTrigger.ForMob triggerStartPanic;

    public GoalPanicOfDamage(T mob, double speedModifier) {
        super(mob);
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        BlockPos blockpos;
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.isTamed()) {
            return false;
        }
        if (!this.shouldPanic()) {
            return false;
        }
        if (this.mob.m_6060_() && (blockpos = this.lookForWater((BlockGetter)this.mob.m_9236_(), (Entity)this.mob, 5)) != null) {
            this.posX = blockpos.m_123341_();
            this.posY = blockpos.m_123342_();
            this.posZ = blockpos.m_123343_();
            return true;
        }
        return this.findRandomPosition();
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        if (this.mob.isTamed()) {
            return false;
        }
        return !this.mob.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.tryToTrigger(this.triggerStartPanic, () -> this.triggerStartPanic.activate((Mob)this.mob));
        this.mob.m_21573_().m_26519_(this.posX, this.posY, this.posZ, this.speedModifier);
        this.isRunning = true;
    }

    public void m_8041_() {
        this.isRunning = false;
    }

    protected boolean findRandomPosition() {
        Vec3 vec3 = DefaultRandomPos.m_148403_((PathfinderMob)this.mob, (int)5, (int)4);
        if (vec3 == null) {
            return false;
        }
        this.posX = vec3.f_82479_;
        this.posY = vec3.f_82480_;
        this.posZ = vec3.f_82481_;
        return true;
    }

    protected BlockPos lookForWater(BlockGetter level, Entity entity, int distance) {
        BlockPos blockpos = entity.m_20183_();
        return !level.m_8055_(blockpos).m_60812_(level, blockpos).m_83281_() ? null : (BlockPos)BlockPos.m_121930_((BlockPos)entity.m_20183_(), (int)distance, (int)1, blockPos -> level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)).orElse(null);
    }

    protected boolean shouldPanic() {
        return this.mob.m_21188_() != null || this.mob.m_203117_() || this.mob.m_6060_();
    }

    public void setTriggerStartPanic(GoalTrigger.ForMob triggerStartPanic) {
        this.triggerStartPanic = triggerStartPanic;
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="Speed")
        private NumberProperty speedModifier = NumberProperty.uniform(1.0);
        private GoalTrigger.ForMob triggerStartPanic;

        public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            GoalPanicOfDamage<BaseAnimal> goal = new GoalPanicOfDamage<BaseAnimal>(animal, this.speedModifier.getDouble());
            goal.setTriggerStartPanic(this.triggerStartPanic);
            return goal;
        }

        @Override
        public void deserialize(JsonObject json) {
            if (json.has("StartPanic")) {
                this.triggerStartPanic = GoalTrigger.ForMob.fromJson(json, "StartPanic");
            }
        }
    }
}

