/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.avoid;

import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.GoalTrigger;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.ScaredMob;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobCondition;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalRunInPanicFromEntity<T extends BaseAnimal>
extends CustomGoal<T> {
    protected final PathNavigation pathNav;
    protected Path path;
    private final TargetingConditions avoidEntityTargeting;
    protected LivingEntity toAvoid;
    private final double walkSpeedModifier;
    private final double sprintSpeedModifier;
    protected final float maxDist;
    private GoalTrigger.ForMobTarget triggerStartPanic;

    public GoalRunInPanicFromEntity(T mob, float maxDist, double walkSpeed, double sprintSpeed, Predicate<LivingEntity> avoidPredicate) {
        super(mob);
        this.maxDist = maxDist;
        this.walkSpeedModifier = walkSpeed;
        this.sprintSpeedModifier = sprintSpeed;
        this.pathNav = mob.m_21573_();
        this.avoidEntityTargeting = TargetingConditions.m_148352_().m_26883_((double)maxDist).m_26888_(avoidPredicate);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        ScaredMob scaredMob;
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.isTamed()) {
            return false;
        }
        BaseAnimal baseAnimal = this.mob;
        if (baseAnimal instanceof ScaredMob && !(scaredMob = (ScaredMob)((Object)baseAnimal)).canBeScared()) {
            return false;
        }
        return this.panicAndRun();
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        if (this.mob.isTamed()) {
            return false;
        }
        BaseAnimal baseAnimal = this.mob;
        if (baseAnimal instanceof ScaredMob) {
            ScaredMob scaredMob = (ScaredMob)((Object)baseAnimal);
            return scaredMob.isScared();
        }
        return this.mob.m_217043_().m_188503_(40) == 0;
    }

    public void m_8056_() {
        this.tryToTrigger(this.triggerStartPanic, () -> this.triggerStartPanic.activate((Mob)this.mob, (Entity)this.toAvoid));
        BaseAnimal baseAnimal = this.mob;
        if (baseAnimal instanceof ScaredMob) {
            ScaredMob scaredMob = (ScaredMob)((Object)baseAnimal);
            scaredMob.setScaredTicks(200);
        }
    }

    public void m_8041_() {
        this.toAvoid = null;
    }

    public void m_8037_() {
        if (this.path == null || this.path.m_77392_()) {
            this.panicAndRun();
        } else {
            this.pathNav.m_26536_(this.path, this.walkSpeedModifier);
        }
        if (this.toAvoid != null) {
            if (this.mob.m_20280_((Entity)this.toAvoid) < 49.0) {
                this.mob.m_21573_().m_26517_(this.sprintSpeedModifier);
            } else {
                this.mob.m_21573_().m_26517_(this.walkSpeedModifier);
            }
        }
    }

    private boolean panicAndRun() {
        this.toAvoid = this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(LivingEntity.class, this.mob.m_20191_().m_82377_((double)this.maxDist, 3.0, (double)this.maxDist), target -> target.m_6095_() != this.mob.m_6095_()), this.avoidEntityTargeting, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
        if (this.toAvoid == null) {
            return false;
        }
        if (this.toAvoid.m_6095_() == this.mob.m_6095_()) {
            return false;
        }
        Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)24, (int)7, (Vec3)this.toAvoid.m_20182_());
        if (vec3 == null) {
            return false;
        }
        if (!(this.toAvoid.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.toAvoid.m_20280_((Entity)this.mob))) {
            this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
            return true;
        }
        return false;
    }

    public void setTriggerStartPanic(GoalTrigger.ForMobTarget triggerStartPanic) {
        this.triggerStartPanic = triggerStartPanic;
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="MaxDistance")
        private NumberProperty maxDistance = NumberProperty.uniform(10.0);
        @JsonField(value="WalkSpeed")
        private NumberProperty walkSpeedModifier = NumberProperty.uniform(1.0);
        @JsonField(value="SprintSpeed")
        private NumberProperty sprintSpeedModifier = NumberProperty.uniform(2.0);
        private Predicate<LivingEntity> targetConditions = target -> true;
        private GoalTrigger.ForMobTarget triggerStartPanic;

        public GoalRunInPanicFromEntity create(BaseAnimal animal) {
            GoalRunInPanicFromEntity<BaseAnimal> goal = new GoalRunInPanicFromEntity<BaseAnimal>(animal, this.maxDistance.getFloat(), this.walkSpeedModifier.getDouble(), this.sprintSpeedModifier.getDouble(), this.targetConditions);
            goal.setTriggerStartPanic(this.triggerStartPanic);
            return goal;
        }

        @Override
        public void deserialize(JsonObject json) {
            if (json.has("TargetConditions")) {
                this.targetConditions = MobCondition.parsePredicate(LivingEntity.class, json, "TargetConditions");
            }
            if (json.has("StartPanic")) {
                this.triggerStartPanic = GoalTrigger.ForMobTarget.fromJson(json, "StartPanic");
            }
        }
    }
}

