/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.avoid;

import com.google.gson.JsonObject;
import java.util.EnumSet;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.GoalTrigger;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.ScaredMob;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalRunInPanicRandomly<T extends BaseAnimal>
extends CustomGoal<T> {
    protected final PathNavigation pathNav;
    protected Path path;
    private final double speedModifier;
    private GoalTrigger.ForMob triggerStartPanic;

    public GoalRunInPanicRandomly(T mob, double speedModifier) {
        super(mob);
        this.speedModifier = speedModifier;
        this.pathNav = mob.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.isTamed()) {
            return false;
        }
        BaseAnimal baseAnimal = this.mob;
        if (baseAnimal instanceof ScaredMob) {
            ScaredMob scaredMob = (ScaredMob)((Object)baseAnimal);
            if (!scaredMob.canBeScared()) {
                return false;
            }
        } else {
            return false;
        }
        return this.panicAndRun();
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        if (this.mob.isTamed()) {
            return false;
        }
        BaseAnimal baseAnimal = this.mob;
        if (baseAnimal instanceof ScaredMob) {
            ScaredMob scaredMob = (ScaredMob)((Object)baseAnimal);
            return scaredMob.isScared();
        }
        return this.mob.m_217043_().m_188503_(40) == 0;
    }

    public void m_8056_() {
        this.tryToTrigger(this.triggerStartPanic, () -> this.triggerStartPanic.activate((Mob)this.mob));
        BaseAnimal baseAnimal = this.mob;
        if (baseAnimal instanceof ScaredMob) {
            ScaredMob scaredMob = (ScaredMob)((Object)baseAnimal);
            scaredMob.setScaredTicks(200);
        }
    }

    public void m_8037_() {
        if (this.path == null || this.path.m_77392_()) {
            this.panicAndRun();
        } else {
            this.pathNav.m_26536_(this.path, this.speedModifier);
        }
        this.mob.m_21573_().m_26517_(this.speedModifier);
    }

    private boolean panicAndRun() {
        Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)24, (int)7, (Vec3)this.mob.m_20182_());
        if (vec3 == null) {
            return false;
        }
        this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
        return true;
    }

    public void setTriggerStartPanic(GoalTrigger.ForMob triggerStartPanic) {
        this.triggerStartPanic = triggerStartPanic;
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="SpeedModifier")
        private NumberProperty speedModifier = NumberProperty.uniform(1.0);
        private GoalTrigger.ForMob triggerStartPanic;

        public GoalRunInPanicRandomly create(BaseAnimal animal) {
            GoalRunInPanicRandomly<BaseAnimal> goal = new GoalRunInPanicRandomly<BaseAnimal>(animal, this.speedModifier.getDouble());
            goal.setTriggerStartPanic(this.triggerStartPanic);
            return goal;
        }

        @Override
        public void deserialize(JsonObject json) {
            if (json.has("StartPanic")) {
                this.triggerStartPanic = GoalTrigger.ForMob.fromJson(json, "StartPanic");
            }
        }
    }
}

