/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.breed;

import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.astemir.astemirlib.common.world.WorldUtils;
import ru.xishnikus.thedawnera.common.block.eggs.TDEBlockEgg;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;

public class GoalLayEgg<T extends BaseAnimal>
extends CustomGoal<T> {
    protected double speed;
    protected BlockPos layPos;
    private BlockState eggBlock;
    protected PositionChooser positionChooser = PositionChooser.LAND;
    protected int layTicks;

    public GoalLayEgg(T mob, BlockState eggBlock, double speed) {
        super(mob);
        this.speed = speed;
        this.eggBlock = eggBlock;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (!this.mob.isPregnant() || this.mob.m_5448_() != null || !RandomUtils.doWithChance((RandomSource)this.mob.m_217043_(), (float)10.0f)) {
            return false;
        }
        BlockPos blockPos = this.positionChooser.getPosition((PathfinderMob)this.mob, this.mob.m_20183_());
        if (blockPos != null) {
            this.layPos = blockPos;
            return this.mob.m_9236_().m_8055_(this.layPos).m_247087_();
        }
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        return this.layPos != null && this.mob.isPregnant();
    }

    public void m_8041_() {
        super.m_8041_();
        this.layTicks = 0;
        this.layPos = null;
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.layPos != null) {
            Vec3 position = Vec3.m_82539_((Vec3i)this.layPos);
            if (this.mob.m_20275_(position.f_82479_, position.f_82480_, position.f_82481_) < this.mob.getReachDistance(2.0)) {
                ++this.layTicks;
                if (this.layTicks % 6 == 0) {
                    this.mob.m_9236_().m_46796_(2001, this.layPos, Block.m_49956_((BlockState)this.mob.m_9236_().m_8055_(this.layPos.m_7495_())));
                }
                if (this.layTicks > this.m_183277_(80)) {
                    this.mob.setPregnant(false);
                    Block block = this.eggBlock.m_60734_();
                    if (block instanceof TDEBlockEgg) {
                        TDEBlockEgg blockEgg = (TDEBlockEgg)block;
                        if (blockEgg.getPropertyEggCount() != null) {
                            this.mob.m_9236_().m_7731_(this.layPos, (BlockState)this.eggBlock.m_61124_((Property)blockEgg.getPropertyEggCount(), (Comparable)Integer.valueOf(RandomUtils.randomInt((RandomSource)this.mob.m_217043_(), (int)1, (int)(blockEgg.getMaxEggs() + 1)))), 3);
                        } else {
                            this.mob.m_9236_().m_7731_(this.layPos, this.eggBlock, 3);
                        }
                    } else {
                        this.mob.m_9236_().m_7731_(this.layPos, this.eggBlock, 3);
                    }
                }
            } else {
                if (this.mob.m_21573_().m_26571_() || this.mob.m_21573_().m_26577_()) {
                    this.mob.m_21573_().m_26536_(this.mob.m_21573_().m_26524_(position.f_82479_, position.f_82480_, position.f_82481_, 0), this.speed);
                }
                this.mob.m_21563_().m_24964_(position);
            }
        }
    }

    public GoalLayEgg<T> setPositionChooser(PositionChooser positionChooser) {
        this.positionChooser = positionChooser;
        return this;
    }

    public boolean m_183429_() {
        return true;
    }

    public static enum PositionChooser {
        WATER((mob, from) -> {
            Level world = mob.m_9236_();
            RandomSource random = mob.m_217043_();
            int range = 20;
            for (int i = 0; i < 20; ++i) {
                BlockPos seafloor = from.m_7918_(random.m_188503_(range) - range / 2, 0, random.m_188503_(range) - range / 2);
                while (world.m_6425_(seafloor).m_205070_(FluidTags.f_13131_) && seafloor.m_123342_() > 1) {
                    seafloor = seafloor.m_7495_();
                }
                BlockState floorState = world.m_8055_(seafloor);
                BlockPos destinationPos = seafloor.m_7494_();
                if (!floorState.m_60713_(Blocks.f_49992_) && !floorState.m_60713_(Blocks.f_49994_) && (!floorState.m_60713_(Blocks.f_50129_) || !world.m_6425_(destinationPos).m_205070_(FluidTags.f_13131_))) continue;
                return destinationPos;
            }
            return null;
        }),
        LAND((mob, from) -> {
            Vec3 vec = LandRandomPos.m_148503_((PathfinderMob)mob, (int)10, (int)10, arg_0 -> ((PathfinderMob)mob).m_21692_(arg_0));
            if (vec != null) {
                BlockPos blockPos = WorldUtils.blockPos((Vec3)vec);
                if (mob.m_9236_().m_8055_(blockPos.m_7495_()).m_204336_(BlockTags.f_184228_)) {
                    return blockPos;
                }
            }
            return null;
        }),
        SEAGRASS((mob, from) -> {
            Level world = mob.m_9236_();
            RandomSource random = mob.m_217043_();
            int range = 5;
            for (int i = 0; i < 5; ++i) {
                BlockPos seafloor = from.m_7918_(random.m_188503_(range) - range / 2, 0, random.m_188503_(range) - range / 2);
                while (world.m_6425_(seafloor).m_205070_(FluidTags.f_13131_) && seafloor.m_123342_() > 1) {
                    seafloor = seafloor.m_7495_();
                }
                BlockPos grassPos = seafloor.m_7494_();
                BlockState state = world.m_8055_(grassPos);
                if (!world.m_8055_(seafloor).m_280296_() || !state.m_60713_(Blocks.f_50037_) && !state.m_60713_(Blocks.f_50038_)) continue;
                return grassPos;
            }
            return null;
        });

        private PosFunc function;

        private PositionChooser(PosFunc function) {
            this.function = function;
        }

        public BlockPos getPosition(PathfinderMob mob, BlockPos from) {
            return this.function.get(mob, from);
        }

        private static interface PosFunc {
            public BlockPos get(PathfinderMob var1, BlockPos var2);
        }
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="Speed")
        protected NumberProperty speedModifier = NumberProperty.uniform(1.0);
        private PositionChooser positionChooser = PositionChooser.LAND;
        private Supplier<BlockState> eggBlock = () -> Blocks.f_50578_.m_49966_();

        public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            return new GoalLayEgg<BaseAnimal>(animal, this.eggBlock.get(), this.speedModifier.getDouble()).setPositionChooser(this.positionChooser);
        }

        @Override
        public void deserialize(JsonObject json) {
            if (json.has("EggBlock")) {
                this.eggBlock = Suppliers.memoize(() -> TDEJsonUtils.parseBlockState(json, "EggBlock"));
            }
            if (json.has("PositionChooser")) {
                this.positionChooser = PositionChooser.valueOf(json.get("PositionChooser").getAsString().toUpperCase());
            }
        }
    }
}

