/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.breed;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalPregnancyBreeding<T extends BaseAnimal>
extends CustomGoal<T> {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    private final Class<T> partnerClass;
    protected final Level level;
    protected T partner;
    private int loveTime;
    private final double speedModifier;

    public GoalPregnancyBreeding(T mob, double speed) {
        this(mob, speed, mob.getClass());
    }

    public GoalPregnancyBreeding(T mob, double speed, Class<T> partnerClass) {
        super(mob);
        this.level = mob.m_9236_();
        this.partnerClass = partnerClass;
        this.speedModifier = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.isPregnant()) {
            return false;
        }
        if (!this.mob.m_27593_()) {
            return false;
        }
        this.partner = this.getFreePartner();
        return this.partner != null && !((BaseAnimal)((Object)this.partner)).isPregnant();
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        return this.partner.m_6084_() && this.partner.m_27593_() && this.loveTime < 60 && !((BaseAnimal)((Object)this.partner)).isPregnant() && !this.mob.isPregnant();
    }

    public void m_8041_() {
        this.partner = null;
        this.loveTime = 0;
    }

    public void m_8037_() {
        this.mob.m_21563_().m_24960_(this.partner, 30.0f, (float)this.mob.m_8132_());
        this.mob.m_21573_().m_5624_(this.partner, this.speedModifier);
        Level level = this.mob.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.mob.f_19797_ % 5 == 0) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.mob.m_20208_(0.5), this.mob.m_20188_(), this.mob.m_20262_(0.5), 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (((BaseAnimal)((Object)this.partner)).f_19797_ % 5 == 0) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.partner.m_20208_(0.5), this.partner.m_20188_(), this.partner.m_20262_(0.5), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (this.mob.m_20280_((Entity)this.partner) < 12.0) {
            ++this.loveTime;
        }
        if (this.loveTime >= this.m_183277_(60)) {
            if (this.mob.getGender().canBePregnant()) {
                this.mob.setPregnant(true);
            } else if (((BaseAnimal)((Object)this.partner)).getGender().canBePregnant()) {
                ((BaseAnimal)((Object)this.partner)).setPregnant(true);
            }
            this.mob.m_27594_();
            this.partner.m_27594_();
        }
    }

    private T getFreePartner() {
        List list = this.level.m_45971_(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.mob, this.mob.m_20191_().m_82400_(8.0));
        double d0 = Double.MAX_VALUE;
        BaseAnimal partner = null;
        for (BaseAnimal animal1 : list) {
            if (!this.mob.getGender().canMate(animal1.getGender()) || !this.mob.m_7848_((Animal)animal1) || !(this.mob.m_20280_((Entity)animal1) < d0)) continue;
            partner = animal1;
            d0 = this.mob.m_20280_((Entity)animal1);
        }
        return (T)((Object)partner);
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="Speed")
        private NumberProperty speedModifier = NumberProperty.uniform(1.0);

        public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            return new GoalPregnancyBreeding<BaseAnimal>(animal, this.speedModifier.getDouble());
        }
    }
}

