/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.breed;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalRandomGiveBirth<T extends BaseAnimal>
extends CustomGoal<T> {
    private int tick;
    private int maxTime;
    private int randomTime;

    public GoalRandomGiveBirth(T mob, int seconds) {
        super(mob);
        this.maxTime = seconds * 20;
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.isPregnant()) {
            this.randomTime = RandomUtils.randomInt((int)((int)((float)this.maxTime * 0.75f)), (int)((int)((float)this.maxTime * 1.25f)));
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        return this.mob.isPregnant();
    }

    public void m_8041_() {
        this.tick = 0;
    }

    public void m_8037_() {
        super.m_8037_();
        ++this.tick;
        if (this.tick >= this.m_183277_(this.randomTime)) {
            this.mob.setPregnant(false);
            Level level = this.mob.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BaseAnimal child = this.mob.getBreedOffspring(serverLevel, (AgeableMob)this.mob);
                child.m_6034_(this.mob.m_20208_(0.5), this.mob.m_20187_(), this.mob.m_20262_(0.5));
                child.m_146762_(-24000);
                serverLevel.m_7967_((Entity)child);
            }
            this.tick = 0;
        }
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="Delay")
        private NumberProperty delay = NumberProperty.uniform(4.0);

        public CustomGoal<BaseAnimal> create(BaseAnimal animal) {
            return new GoalRandomGiveBirth<BaseAnimal>(animal, this.delay.getInt());
        }
    }
}

