/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobCondition;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalFollowEntity<T extends BaseAnimal>
extends CustomGoal<T> {
    private final double speedModifier;
    private final double visibilityDistance;
    private final double maxDistance;
    private LivingEntity followedEntity;
    private int timeToRecalcPath;
    private Predicate<LivingEntity> toFollow;

    public GoalFollowEntity(T mob, double speed, double visibilityDistance, double maxDistance, Predicate<LivingEntity> toFollow) {
        super(mob);
        this.speedModifier = speed;
        this.visibilityDistance = visibilityDistance;
        this.maxDistance = maxDistance;
        this.toFollow = toFollow;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (!RandomUtils.doWithChance((RandomSource)this.mob.m_217043_(), (float)5.0f)) {
            return false;
        }
        List list = this.mob.m_9236_().m_6443_(LivingEntity.class, this.mob.m_20191_().m_82377_(this.visibilityDistance, this.visibilityDistance, this.visibilityDistance), this.toFollow);
        LivingEntity entity = null;
        double d0 = 0.0;
        for (LivingEntity livingEntity : list) {
            double d1;
            if (livingEntity.m_20148_() == this.mob.m_20148_() || !((d1 = this.mob.m_20280_((Entity)livingEntity)) > d0)) continue;
            d0 = d1;
            entity = livingEntity;
        }
        if (entity == null) {
            return false;
        }
        if (d0 < this.maxDistance * this.maxDistance) {
            return false;
        }
        this.followedEntity = entity;
        return true;
    }

    public boolean m_8045_() {
        if (!super.m_8045_()) {
            return false;
        }
        double d0 = this.mob.m_20280_((Entity)this.followedEntity);
        return d0 > this.maxDistance * this.maxDistance && d0 < 256.0;
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
    }

    public void m_8041_() {
        this.followedEntity = null;
    }

    public void m_8037_() {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            this.mob.m_21573_().m_5624_((Entity)this.followedEntity, this.speedModifier);
        }
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="VisibilityDistance")
        private NumberProperty visibilityDistance = NumberProperty.uniform(16.0);
        @JsonField(value="AcceptableDistance")
        private NumberProperty acceptableDistance = NumberProperty.uniform(8.0);
        @JsonField(value="Speed")
        private NumberProperty speedModifier = NumberProperty.uniform(1.0);
        private Predicate<LivingEntity> targetConditions = target -> true;

        public GoalFollowEntity create(BaseAnimal animal) {
            return new GoalFollowEntity<BaseAnimal>(animal, this.speedModifier.getDouble(), this.visibilityDistance.getInt(), this.acceptableDistance.getInt(), this.targetConditions);
        }

        @Override
        public void deserialize(JsonObject json) {
            if (json.has("TargetConditions")) {
                this.targetConditions = MobCondition.parsePredicate(LivingEntity.class, json, "TargetConditions");
            }
        }
    }
}

