/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseWaterAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalFollowOwner<T extends BaseAnimal>
extends CustomGoal<T> {
    private LivingEntity owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private final float teleportDistance;
    private float oldWaterCost;
    private final boolean canFly;

    public GoalFollowOwner(T mob, double speedModifier, float startDistance, float stopDistance, float teleportDistance, boolean canFly) {
        super(mob);
        this.level = mob.m_9236_();
        this.speedModifier = speedModifier;
        this.navigation = mob.m_21573_();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.teleportDistance = teleportDistance;
        this.canFly = canFly;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        LivingEntity livingentity = this.mob.m_269323_();
        if (livingentity == null) {
            return false;
        }
        if (this.mob.getMovementOrderType() == MobOrder.Movement.WANDER) {
            return false;
        }
        if (livingentity.m_5833_()) {
            return false;
        }
        if (this.mob.m_20159_() || this.mob.m_21523_()) {
            return false;
        }
        if (this.mob.getMovementOrderType() == MobOrder.Movement.FOLLOW && this.mob.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (this.mob.getMovementOrderType() == MobOrder.Movement.WANDER) {
            return false;
        }
        if (this.mob.m_20159_() || this.mob.m_21523_()) {
            return false;
        }
        return this.mob.getMovementOrderType() == MobOrder.Movement.FOLLOW && !(this.mob.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.m_21439_(BlockPathTypes.WATER);
        this.mob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        if (this.mob.getMovementOrderType() == MobOrder.Movement.FOLLOW) {
            this.mob.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.mob.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                if (this.mob.m_20280_((Entity)this.owner) >= (double)(this.teleportDistance * this.teleportDistance)) {
                    this.teleportToOwner();
                } else {
                    this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.mob.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.mob.m_146908_(), this.mob.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos p_25308_) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)p_25308_.m_122032_());
        if (this.mob instanceof BaseWaterAnimal) {
            if (blockpathtypes != BlockPathTypes.WATER) {
                return false;
            }
            BlockState blockstate = this.level.m_8055_(p_25308_.m_7495_());
            if (!this.canFly && blockstate.m_60734_() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockpos = p_25308_.m_121996_((Vec3i)this.mob.m_20183_());
            return this.level.m_45756_((Entity)this.mob, this.mob.m_20191_().m_82338_(blockpos));
        }
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level.m_8055_(p_25308_.m_7495_());
        if (!this.canFly && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = p_25308_.m_121996_((Vec3i)this.mob.m_20183_());
        return this.level.m_45756_((Entity)this.mob, this.mob.m_20191_().m_82338_(blockpos));
    }

    private int randomIntInclusive(int p_25301_, int p_25302_) {
        return this.mob.m_217043_().m_188503_(p_25302_ - p_25301_ + 1) + p_25301_;
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="Speed")
        private NumberProperty speedModifier = NumberProperty.uniform(1.0);
        @JsonField(value="StartFollowDistance")
        private NumberProperty startDistance = NumberProperty.uniform(8.0);
        @JsonField(value="StopFollowDistance")
        private NumberProperty stopDistance = NumberProperty.uniform(2.0);
        @JsonField(value="TeleportDistance")
        private NumberProperty teleportDistance = NumberProperty.uniform(24.0);
        @JsonField(value="CanFly")
        private boolean canFly = false;

        public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            return new GoalFollowOwner<BaseAnimal>(animal, this.speedModifier.getDouble(), (float)this.startDistance.getDouble(), (float)this.stopDistance.getDouble(), (float)this.teleportDistance.getDouble(), this.canFly);
        }
    }
}

