/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import net.minecraft.world.entity.Entity;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.PackMob;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalFollowPackLeader<T extends BaseAnimal>
extends CustomGoal<T> {
    private PackMob packMob;
    private PackMob priorPackMob;
    private final double speedModifier;
    private float maxAcceptableDistance;
    private int timeToRecalcPath;

    public GoalFollowPackLeader(T mob, double speedModifier, float maxAcceptableDistance) {
        super(mob);
        this.packMob = (PackMob)mob;
        this.speedModifier = speedModifier;
        this.maxAcceptableDistance = maxAcceptableDistance;
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        BaseAnimal baseAnimal = this.mob;
        if (baseAnimal instanceof PackMob) {
            PackMob packMob = (PackMob)((Object)baseAnimal);
            if (this.mob.isTamed() && this.mob.getMovementOrderType() != MobOrder.Movement.WANDER) {
                return false;
            }
            this.priorPackMob = packMob.getPriorPackMember();
            if (this.priorPackMob != null) {
                double d0 = this.mob.m_20280_((Entity)this.priorPackMob);
                return !(d0 < (double)(this.maxAcceptableDistance * this.maxAcceptableDistance));
            }
        }
        return false;
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        if (this.mob.isTamed() && this.mob.getMovementOrderType() != MobOrder.Movement.WANDER) {
            return false;
        }
        if (this.priorPackMob != null) {
            double d0 = this.mob.m_20280_((Entity)this.priorPackMob);
            return !(d0 < 9.0) && !(d0 > 256.0);
        }
        return false;
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
    }

    public void m_8041_() {
        this.priorPackMob = null;
    }

    public void m_8037_() {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            this.mob.m_21573_().m_5624_((Entity)this.priorPackMob, this.speedModifier);
        }
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="Speed")
        private NumberProperty speedModifier = NumberProperty.uniform(1.0);
        @JsonField(value="AcceptableDistance")
        private NumberProperty maxAcceptableDistance = NumberProperty.uniform(10.0);

        public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            return new GoalFollowPackLeader<BaseAnimal>(animal, this.speedModifier.getDouble(), this.maxAcceptableDistance.getFloat());
        }
    }
}

