/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalFollowParent<T extends BaseAnimal>
extends CustomGoal<T> {
    private Animal parent;
    private final double speedModifier;
    private float visibilityDistance;
    private float maxAcceptableDistance;
    private int timeToRecalcPath;

    public GoalFollowParent(T mob, double speedModifier, float visibilityDistance, float maxAcceptableDistance) {
        super(mob);
        this.speedModifier = speedModifier;
        this.visibilityDistance = visibilityDistance;
        this.maxAcceptableDistance = maxAcceptableDistance;
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.m_146764_() >= 0) {
            return false;
        }
        if (this.mob.isTamed() && this.mob.getMovementOrderType() != MobOrder.Movement.WANDER) {
            return false;
        }
        List list = this.mob.m_9236_().m_45976_(((Object)((Object)this.mob)).getClass(), this.mob.m_20191_().m_82377_((double)this.visibilityDistance, (double)this.visibilityDistance, (double)this.visibilityDistance));
        Animal animal = null;
        double d0 = Double.MAX_VALUE;
        for (Animal animal1 : list) {
            double d1;
            if (animal1.m_146764_() < 0 || (d1 = this.mob.m_20280_((Entity)animal1)) > d0) continue;
            d0 = d1;
            animal = animal1;
        }
        if (animal == null) {
            return false;
        }
        if (d0 < (double)(this.maxAcceptableDistance * this.maxAcceptableDistance)) {
            return false;
        }
        this.parent = animal;
        return true;
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        if (this.mob.m_146764_() >= 0) {
            return false;
        }
        if (!this.parent.m_6084_()) {
            return false;
        }
        if (this.mob.isTamed() && this.mob.getMovementOrderType() != MobOrder.Movement.WANDER) {
            return false;
        }
        double d0 = this.mob.m_20280_((Entity)this.parent);
        return !(d0 < 9.0) && !(d0 > 256.0);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
    }

    public void m_8041_() {
        this.parent = null;
    }

    public void m_8037_() {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            this.mob.m_21573_().m_5624_((Entity)this.parent, this.speedModifier);
        }
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="Speed")
        private NumberProperty speedModifier = NumberProperty.uniform(1.0);
        @JsonField(value="VisibilityDistance")
        private NumberProperty visibilityDistance = NumberProperty.uniform(16.0);
        @JsonField(value="AcceptableDistance")
        private NumberProperty acceptableDistance = NumberProperty.uniform(8.0);

        public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            return new GoalFollowParent<BaseAnimal>(animal, this.speedModifier.getDouble(), this.visibilityDistance.getFloat(), this.acceptableDistance.getFloat());
        }
    }
}

