/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemStack;
import ru.xishnikus.thedawnera.common.TDELevelEvents;
import ru.xishnikus.thedawnera.common.entity.ai.goal.move.GoalMoveToBlock;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;

public class GoalGoAndEatBlock<T extends BaseAnimal>
extends GoalMoveToBlock<T> {
    public GoalGoAndEatBlock(T mob, double speedModifier, int searchRange, int verticalSearchRange, int randomTick, float acceptableDistance, BiPredicate predicate) {
        super(mob, speedModifier, searchRange, verticalSearchRange, randomTick, acceptableDistance, predicate);
    }

    @Override
    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.m_6688_() != null) {
            return false;
        }
        if (this.mob.actionController.isNoAction() && (this.mob.getFoodOrderType() != MobOrder.Eating.DENY_EAT || !this.mob.isTamed())) {
            if (this.nextStartTick > 0) {
                --this.nextStartTick;
                return false;
            }
            this.nextStartTick = this.nextStartTick((PathfinderMob)this.mob);
            return this.findNearestBlock();
        }
        return false;
    }

    @Override
    public void achieveBlock(BlockPos blockPos) {
        ItemStack itemStack = this.mob.m_9236_().m_8055_(blockPos).m_60734_().m_5456_().m_7968_();
        TDELevelEvents.eatFood((LivingEntity)this.mob, itemStack);
        this.mob.m_9236_().m_46961_(blockPos, false);
        this.mob.eat(4.0f);
    }

    public static class Builder
    extends GoalMoveToBlock.Builder {
        @Override
        public GoalGoAndEatBlock create(BaseAnimal animal) {
            GoalGoAndEatBlock<BaseAnimal> goal = new GoalGoAndEatBlock<BaseAnimal>(animal, this.speedModifier.getDouble(), this.horizontalDistance.getInt(), this.verticalDistance.getInt(), this.interval.getInt(), (float)this.acceptableDistance.getInt(), this.predicate);
            goal.setTriggerAchievePos(this.achievePos);
            return goal;
        }
    }
}

