/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import ru.xishnikus.thedawnera.common.TDELevelEvents;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.GoalTrigger;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobCondition;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobTameMethod;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalGoAndEatFood<T extends BaseAnimal>
extends CustomGoal<T> {
    private ItemEntity foodEntity;
    private double horizontalRadius;
    private double verticalRadius;
    private double speedModifier;
    private int maxItemCountCanEat = 1;
    private Predicate<ItemEntity> canEatItemCondition;
    private GoalTrigger.ForMob triggerEatItem;

    public GoalGoAndEatFood(T mob, double speedModifier, double horizontalRadius, double verticalRadius, int maxItemCountCanEat) {
        super(mob);
        this.horizontalRadius = horizontalRadius;
        this.verticalRadius = verticalRadius;
        this.speedModifier = speedModifier;
        this.maxItemCountCanEat = maxItemCountCanEat;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.isTamed() && this.mob.getFoodOrderType() == MobOrder.Eating.DENY_EAT) {
            return false;
        }
        if (this.mob.m_5448_() == null && this.mob.m_21188_() == null) {
            return this.searchForFood();
        }
        return false;
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        if (this.mob.isTamed() && this.mob.getFoodOrderType() == MobOrder.Eating.DENY_EAT) {
            return false;
        }
        if (this.foodEntity == null) {
            return false;
        }
        return super.m_8045_();
    }

    @Override
    public boolean isShouldCanBeUsedToContinue() {
        return true;
    }

    public void m_8037_() {
        if (this.mob.m_20280_((Entity)this.foodEntity) < this.mob.getReachDistanceTo((Entity)this.foodEntity, 2.0)) {
            TDELevelEvents.eatFood((LivingEntity)this.mob, this.tryToEatItemsOnGround(this.mob, this.maxItemCountCanEat, () -> this.tryToTrigger(this.triggerEatItem, () -> this.triggerEatItem.activate((Mob)this.mob))));
        } else {
            this.moveToFood();
        }
    }

    public void m_8056_() {
        this.moveToFood();
    }

    protected boolean searchForFood() {
        List list = this.mob.m_9236_().m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(this.horizontalRadius, this.verticalRadius, this.horizontalRadius), itemEntity -> this.mob.getMobRation().canBeEaten((LivingEntity)this.mob, itemEntity.m_32055_()));
        if (!list.isEmpty()) {
            for (ItemEntity itemEntity2 : list) {
                if (this.canEatItemCondition != null && !this.canEatItemCondition.test(itemEntity2)) continue;
                this.foodEntity = itemEntity2;
                return true;
            }
        }
        return false;
    }

    public ItemEntity getNearestEatableItem(BaseAnimal mob) {
        List foodItems = mob.m_9236_().m_6443_(ItemEntity.class, mob.m_20191_().m_82377_(1.5, 1.0, 1.5), entity -> mob.getMobRation().canBeEaten((LivingEntity)mob, entity.m_32055_()));
        if (!foodItems.isEmpty()) {
            return (ItemEntity)foodItems.get(0);
        }
        return null;
    }

    public ItemStack tryToEatItemsOnGround(BaseAnimal mob, int maxCount, Runnable success) {
        ItemEntity itemEntity;
        if (!mob.m_9236_().f_46443_ && !mob.m_21224_() && mob.getFoodOrderType() == MobOrder.Eating.ALLOW_EAT && (itemEntity = this.getNearestEatableItem(mob)) != null && itemEntity.f_19797_ > 20) {
            ItemStack itemStack = itemEntity.m_32055_();
            ItemStack copy = itemStack.m_41777_();
            int eatenCount = Math.min(itemStack.m_41613_(), maxCount);
            if (itemStack.m_41613_() > 1) {
                itemStack.m_41774_(eatenCount);
                itemEntity.m_32045_(itemStack);
            } else {
                itemEntity.m_6074_();
            }
            mob.eat((float)eatenCount * (mob.getMaxHunger() / 4.0f));
            Entity entity = itemEntity.m_19749_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (mob.canBeTamedBy(MobTameMethod.Type.FEED_FROM_GROUND)) {
                    MobTameMethod.FeedWithItem.tameEatFromHand(player, mob, itemStack);
                }
            }
            success.run();
            return copy;
        }
        return ItemStack.f_41583_;
    }

    protected void moveToFood() {
        this.mob.m_21573_().m_26536_(this.mob.m_21573_().m_26524_(this.foodEntity.m_20185_(), this.foodEntity.m_20186_(), this.foodEntity.m_20189_(), 0), this.speedModifier);
        this.mob.m_21563_().m_24946_(this.foodEntity.m_20185_(), this.foodEntity.m_20186_() + 0.5, this.foodEntity.m_20189_());
    }

    public void setCanEatItemCondition(Predicate<ItemEntity> canEatItemCondition) {
        this.canEatItemCondition = canEatItemCondition;
    }

    public void setTriggerEatItem(GoalTrigger.ForMob triggerEatItem) {
        this.triggerEatItem = triggerEatItem;
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="Speed")
        private NumberProperty speedModifier = NumberProperty.uniform(3000.0);
        @JsonField(value="HorizontalDistance")
        private NumberProperty horizontalDistance = NumberProperty.uniform(10.0);
        @JsonField(value="VerticalDistance")
        private NumberProperty verticalDistance = NumberProperty.uniform(3.0);
        @JsonField(value="MaxItemCountCanEat")
        private NumberProperty maxItemsCanEat = NumberProperty.uniform(1.0);
        private Predicate<ItemEntity> targetConditions = item -> true;
        private GoalTrigger.ForMob eatItem;

        public GoalGoAndEatFood create(BaseAnimal animal) {
            GoalGoAndEatFood<BaseAnimal> goal = new GoalGoAndEatFood<BaseAnimal>(animal, this.speedModifier.getDouble(), this.horizontalDistance.getDouble(), this.verticalDistance.getDouble(), this.maxItemsCanEat.getInt());
            goal.setTriggerEatItem(this.eatItem);
            goal.setCanEatItemCondition(this.targetConditions);
            return goal;
        }

        @Override
        public void deserialize(JsonObject json) {
            if (json.has("TargetConditions")) {
                this.targetConditions = MobCondition.parsePredicate(ItemEntity.class, json, "TargetConditions");
            }
            if (json.has("FoodEat")) {
                this.eatItem = GoalTrigger.ForMob.fromJson(json, "FoodEat");
            }
        }
    }
}

