/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import java.util.List;
import net.minecraft.world.entity.Entity;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.PackMob;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalJoinPack<T extends BaseAnimal>
extends CustomGoal<T> {
    public final PackMob packMob;
    private int distCheckCounter;
    private int interval;
    private int packSize;

    public GoalJoinPack(T mob, int interval, int packSize) {
        super(mob);
        this.packMob = (PackMob)mob;
        this.interval = interval;
        this.packSize = packSize;
    }

    public boolean m_8036_() {
        long worldTime = this.mob.m_9236_().m_46467_() % 10L;
        if (worldTime != 0L && this.mob.m_217043_().m_188503_(GoalJoinPack.m_186073_((int)this.interval)) != 0) {
            return false;
        }
        if (!this.packMob.isPackFollower() && !this.packMob.hasPackFollower()) {
            double dist = 30.0;
            List list = this.mob.m_9236_().m_45976_(((Object)((Object)this.mob)).getClass(), this.mob.m_20191_().m_82377_(dist, dist, dist));
            BaseAnimal closestTail = null;
            double d0 = Double.MAX_VALUE;
            for (BaseAnimal animal : list) {
                double d1;
                if (((PackMob)((Object)animal)).hasPackFollower() || !((PackMob)((Object)animal)).isValidLeader(((PackMob)((Object)animal)).getPackLeader()) || animal.m_20148_().equals(this.mob.m_20148_()) || ((PackMob)((Object)animal)).isInPack(this.packMob) || ((PackMob)((Object)animal)).getPackSize() >= this.packSize || (d1 = this.mob.m_20280_((Entity)animal)) > d0) continue;
                d0 = d1;
                closestTail = animal;
            }
            if (closestTail == null) {
                return false;
            }
            if (d0 < 1.0) {
                return false;
            }
            if (!this.packMob.isValidLeader(((PackMob)((Object)closestTail)).getPackLeader())) {
                return false;
            }
            this.packMob.joinPackOf((PackMob)((Object)closestTail));
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.packMob.isPackFollower() && this.packMob.isValidLeader(this.packMob.getPackLeader())) {
            double d0 = this.mob.m_20280_((Entity)((BaseAnimal)((Object)this.packMob.getPriorPackMember())));
            if (d0 > 676.0 && this.distCheckCounter == 0) {
                return false;
            }
            if (this.distCheckCounter > 0) {
                --this.distCheckCounter;
            }
            return true;
        }
        return false;
    }

    public void m_8041_() {
        this.packMob.leavePack();
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="Interval")
        private NumberProperty interval = NumberProperty.uniform(20.0);
        @JsonField(value="MaxPackSize")
        private NumberProperty maxPackSize = NumberProperty.uniform(10.0);

        public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            return new GoalJoinPack<BaseAnimal>(animal, this.interval.getInt(), this.maxPackSize.getInt());
        }
    }
}

