/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalJumpOutOfWater<T extends BaseAnimal>
extends CustomGoal<T> {
    private double horizontalSpeed;
    private double verticalSpeed;

    public GoalJumpOutOfWater(T mob, double horizontalSpeed, double verticalSpeed) {
        super(mob);
        this.horizontalSpeed = horizontalSpeed;
        this.verticalSpeed = verticalSpeed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.actionController.is(this.getJumpState())) {
            return false;
        }
        return this.mob.m_20069_() && this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7494_()).m_60795_();
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        return this.mob.actionController.is(this.getJumpState());
    }

    public void m_8056_() {
        Vec3 viewVec = this.mob.m_20252_(0.0f);
        this.mob.actionController.playAction(this.getJumpState());
        this.mob.m_20334_(viewVec.f_82479_ * this.horizontalSpeed, this.verticalSpeed, viewVec.f_82481_ * this.horizontalSpeed);
        this.mob.f_19812_ = true;
        this.mob.m_21573_().m_26573_();
    }

    public void m_8041_() {
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        Vec3 vec3 = this.mob.m_20184_();
        double d0 = vec3.m_165924_();
        float xRot = (float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875);
        this.mob.m_146926_(MathUtils.lerp((float)this.mob.m_146909_(), (float)(-xRot), (float)0.4f));
    }

    private ActionState getJumpState() {
        return this.mob.actionController.getActionByName("jump");
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="HorizontalSpeed")
        private NumberProperty horizontalSpeed = NumberProperty.uniform(0.6f);
        @JsonField(value="VerticalSpeed")
        private NumberProperty verticalSpeed = NumberProperty.uniform(0.8f);

        public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            return new GoalJumpOutOfWater<BaseAnimal>(animal, this.horizontalSpeed.getDouble(), this.verticalSpeed.getDouble());
        }
    }
}

