/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.GoalTrigger;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.entity.properties.predicate.BlockPredicate;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalMoveToBlock<T extends BaseAnimal>
extends CustomGoal<T> {
    protected BlockPos blockPos = BlockPos.f_121853_;
    public final double speedModifier;
    private float acceptableDistance;
    protected int nextStartTick;
    protected int tryTicks;
    protected int maxStayTicks;
    protected int randomTick;
    private final int searchRange;
    private final int verticalSearchRange;
    private final int verticalSearchStart;
    private boolean reachedTarget;
    private GoalTrigger.ForMobBlockPos triggerAchievePos;
    private BiPredicate<BlockPos, BlockState> predicate;

    public GoalMoveToBlock(T mob, double speedModifier, int searchRange, int verticalSearchRange, int randomTick, float acceptableDistance, BiPredicate<BlockPos, BlockState> predicate) {
        super(mob);
        this.speedModifier = speedModifier;
        this.searchRange = searchRange;
        this.verticalSearchStart = 0;
        this.verticalSearchRange = verticalSearchRange;
        this.randomTick = randomTick;
        this.acceptableDistance = acceptableDistance;
        this.predicate = predicate;
        this.nextStartTick = this.nextStartTick((PathfinderMob)this.mob);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        this.nextStartTick = this.nextStartTick((PathfinderMob)this.mob);
        return this.findNearestBlock();
    }

    protected int nextStartTick(PathfinderMob mob) {
        return GoalMoveToBlock.m_186073_((int)(this.randomTick + mob.m_217043_().m_188503_(this.randomTick)));
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        return !this.reachedTarget && this.tryTicks >= -this.maxStayTicks && this.tryTicks <= 300 && this.predicate.test(this.blockPos, this.mob.m_9236_().m_8055_(this.blockPos));
    }

    public void m_8056_() {
        this.moveMobToBlock();
        this.tryTicks = 0;
        this.reachedTarget = false;
        this.maxStayTicks = this.mob.m_217043_().m_188503_(this.mob.m_217043_().m_188503_(1200) + 1200) + 1200;
    }

    protected void moveMobToBlock() {
        this.mob.m_21573_().m_26536_(this.mob.m_21573_().m_26524_((double)this.blockPos.m_123341_() + 0.5, (double)this.blockPos.m_123342_(), (double)this.blockPos.m_123343_() + 0.5, 0), this.speedModifier);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (!this.blockPos.m_203195_((Position)this.mob.m_20182_(), (double)this.acceptableDistance)) {
            this.reachedTarget = false;
            ++this.tryTicks;
            if (this.shouldRecalculatePath()) {
                this.moveMobToBlock();
            }
            this.mob.m_21563_().m_24946_((double)this.blockPos.m_123341_() + 0.5, (double)this.blockPos.m_123342_() + 0.5, (double)this.blockPos.m_123343_() + 0.5);
        } else {
            if (!this.reachedTarget) {
                this.reachedTarget = true;
                this.achieveBlock(this.blockPos);
                if (this.triggerAchievePos != null) {
                    this.triggerAchievePos.activate((Mob)this.mob, this.blockPos);
                }
            }
            --this.tryTicks;
        }
    }

    protected boolean findNearestBlock() {
        int i = this.searchRange;
        int j = this.verticalSearchRange;
        BlockPos blockpos = this.mob.m_20183_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int k = this.verticalSearchStart;
        while (k <= j) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        mutablePos.m_122154_((Vec3i)blockpos, i1, k - 1, j1);
                        if (this.mob.m_21444_((BlockPos)mutablePos) && this.predicate.test((BlockPos)mutablePos, this.mob.m_9236_().m_8055_((BlockPos)mutablePos))) {
                            this.blockPos = mutablePos;
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return false;
    }

    public boolean shouldRecalculatePath() {
        return this.tryTicks % 40 == 0;
    }

    public void achieveBlock(BlockPos blockPos) {
    }

    public void setTriggerAchievePos(GoalTrigger.ForMobBlockPos triggerAchievePos) {
        this.triggerAchievePos = triggerAchievePos;
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="Speed")
        protected NumberProperty speedModifier = NumberProperty.uniform(1.0);
        @JsonField(value="HorizontalDistance")
        protected NumberProperty horizontalDistance = NumberProperty.uniform(10.0);
        @JsonField(value="VerticalDistance")
        protected NumberProperty verticalDistance = NumberProperty.uniform(4.0);
        @JsonField(value="Interval")
        protected NumberProperty interval = NumberProperty.uniform(20.0);
        @JsonField(value="AcceptableDistance")
        protected NumberProperty acceptableDistance = NumberProperty.uniform(2.0);
        protected BiPredicate<BlockPos, BlockState> predicate = (pos, state) -> false;
        protected GoalTrigger.ForMobBlockPos achievePos;

        public GoalMoveToBlock create(BaseAnimal animal) {
            GoalMoveToBlock<BaseAnimal> goal = new GoalMoveToBlock<BaseAnimal>(animal, this.speedModifier.getDouble(), this.horizontalDistance.getInt(), this.verticalDistance.getInt(), this.interval.getInt(), this.acceptableDistance.getInt(), this.predicate);
            goal.setTriggerAchievePos(this.achievePos);
            return goal;
        }

        @Override
        public void deserialize(JsonObject json) {
            if (json.has("Blocks")) {
                List<BlockPredicate> foodBlocks = BlockPredicate.parseBlocks(json, "Blocks");
                this.predicate = (pos, state) -> {
                    for (BlockPredicate blockPredicate : foodBlocks) {
                        if (!blockPredicate.test((BlockState)state)) continue;
                        return true;
                    }
                    return false;
                };
            }
            if (json.has("AchievePos")) {
                this.achievePos = GoalTrigger.ForMobBlockPos.fromJson(json, "AchievePos");
            }
        }
    }
}

