/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import ru.astemir.astemirlib.client.bedrock.json.JsonParser;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.GoalTrigger;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobCondition;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalMoveToEntity<T extends BaseAnimal>
extends CustomGoal<T> {
    private Predicate<Entity> predicate;
    protected Entity target;
    public final double speedModifier;
    protected int nextStartTick;
    protected int tryTicks;
    private int maxStayTicks;
    private final int searchRange;
    private final int verticalSearchRange;
    protected int verticalSearchStart;
    private int randomTick;
    private boolean reachedTarget;
    private AVector3f targetOffset = new AVector3f(0.0f, 0.0f, 0.0f);
    private Predicate<Entity> canTargetCondition = m -> true;
    private GoalTrigger.ForMobTarget triggerAchieveEntity;
    private double acceptableDistance = 2.0;

    public GoalMoveToEntity(T mob, double speedModifier, int searchRange, int verticalSearchRange, int randomTick, Predicate<Entity> predicate) {
        super(mob);
        this.speedModifier = speedModifier;
        this.searchRange = searchRange;
        this.verticalSearchStart = 0;
        this.verticalSearchRange = verticalSearchRange;
        this.randomTick = randomTick;
        this.predicate = predicate;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        this.nextStartTick = GoalMoveToEntity.m_186073_((int)(this.randomTick + this.mob.m_217043_().m_188503_(this.randomTick)));
        return this.findNearestEntity();
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        return !this.reachedTarget && this.tryTicks >= -this.maxStayTicks && this.tryTicks <= 1200 && this.predicate.test(this.target);
    }

    public void m_8056_() {
        this.moveMobToBlock();
        this.tryTicks = 0;
        this.reachedTarget = false;
        this.maxStayTicks = this.mob.m_217043_().m_188503_(this.mob.m_217043_().m_188503_(1200) + 1200) + 1200;
    }

    protected void moveMobToBlock() {
        this.mob.m_21573_().m_26536_(this.mob.m_21573_().m_26524_((double)((float)this.target.m_20185_() + this.targetOffset.x), this.target.m_20186_() + (double)this.targetOffset.y, (double)((float)this.target.m_20189_() + this.targetOffset.z), 0), this.speedModifier);
    }

    public Entity getTarget() {
        return this.target;
    }

    public boolean m_183429_() {
        return true;
    }

    public void achieveEntity(Entity entity) {
    }

    public void m_8037_() {
        if (this.mob.m_20280_(this.target) > this.mob.getReachDistanceTo(this.target, this.acceptableDistance)) {
            this.reachedTarget = false;
            ++this.tryTicks;
            if (this.shouldRecalculatePath()) {
                this.mob.m_21573_().m_26536_(this.mob.m_21573_().m_26524_((double)((float)this.target.m_20185_() + this.targetOffset.x), this.target.m_20186_() + (double)this.targetOffset.y, (double)((float)this.target.m_20189_() + this.targetOffset.z), 0), this.speedModifier);
            }
            this.mob.m_21563_().m_24946_((double)((float)this.target.m_20185_() + this.targetOffset.x), this.target.m_20186_() + (double)(this.target.m_20206_() * 0.75f) + (double)this.targetOffset.y, (double)((float)this.target.m_20189_() + this.targetOffset.z));
        } else {
            if (!this.reachedTarget) {
                this.reachedTarget = true;
                this.achieveEntity(this.target);
                this.tryToTrigger(this.triggerAchieveEntity, () -> this.triggerAchieveEntity.activate((Mob)this.mob, this.target));
            }
            --this.tryTicks;
        }
    }

    public boolean shouldRecalculatePath() {
        return this.tryTicks % 40 == 0;
    }

    protected boolean findNearestEntity() {
        int i = this.searchRange;
        int j = this.verticalSearchRange;
        for (Entity entity : this.mob.m_9236_().m_6249_((Entity)this.mob, this.mob.m_20191_().m_82377_((double)i, (double)j, (double)i), this.predicate)) {
            if (entity == null || entity == this.mob || !this.canTargetCondition.test(entity)) continue;
            this.target = entity;
            return true;
        }
        return false;
    }

    public void setTargetOffset(AVector3f targetOffset) {
        this.targetOffset = targetOffset;
    }

    public void setCanTargetCondition(Predicate<Entity> canTargetCondition) {
        this.canTargetCondition = canTargetCondition;
    }

    public void setTriggerAchieveEntity(GoalTrigger.ForMobTarget triggerAchieveEntity) {
        this.triggerAchieveEntity = triggerAchieveEntity;
    }

    public void setAcceptableDistance(double acceptableDistance) {
        this.acceptableDistance = acceptableDistance;
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="HorizontalDistance")
        protected NumberProperty horizontalDistance = NumberProperty.uniform(8.0);
        @JsonField(value="VerticalDistance")
        protected NumberProperty verticalDistance = NumberProperty.uniform(10.0);
        @JsonField(value="Interval")
        protected NumberProperty interval = NumberProperty.uniform(20.0);
        @JsonField(value="Speed")
        protected NumberProperty speedModifier = NumberProperty.uniform(1.0);
        @JsonField(value="AcceptableDistance")
        protected NumberProperty acceptableDistance = NumberProperty.uniform(2.0);
        private AVector3f targetOffset = new AVector3f(0.0f, 0.5f, 0.0f);
        private Predicate<Entity> targetConditions = target -> true;
        private GoalTrigger.ForMobTarget achieveEntity;

        public GoalMoveToEntity create(BaseAnimal animal) {
            GoalMoveToEntity<BaseAnimal> goal = new GoalMoveToEntity<BaseAnimal>(animal, this.speedModifier.getDouble(), this.horizontalDistance.getInt(), this.verticalDistance.getInt(), this.interval.getInt(), this.targetConditions);
            goal.setAcceptableDistance(this.acceptableDistance.getDouble());
            goal.setTargetOffset(this.targetOffset);
            goal.setTriggerAchieveEntity(this.achieveEntity);
            goal.setCanTargetCondition(this.targetConditions);
            return goal;
        }

        @Override
        public void deserialize(JsonObject json) {
            if (json.has("TargetOffset")) {
                this.targetOffset = JsonParser.getAsVec3((JsonObject)json, (String)"TargetOffset");
            }
            if (json.has("TargetConditions")) {
                this.targetConditions = MobCondition.parsePredicate(Entity.class, json, "TargetConditions");
            }
            if (json.has("AchievePos")) {
                this.achieveEntity = GoalTrigger.ForMobTarget.fromJson(json, "AchievePos");
            }
        }
    }
}

