/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.GoalTrigger;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;

public class GoalOpenDoor<T extends BaseAnimal>
extends CustomGoal<T> {
    protected BlockPos doorPos = BlockPos.f_121853_;
    protected boolean hasDoor;
    private boolean passed;
    private float doorOpenDirX;
    private float doorOpenDirZ;
    private GoalTrigger.ForMobBlockPos triggerOpenDoor;

    public GoalOpenDoor(T mob) {
        super(mob);
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (!GoalUtils.m_26894_((Mob)this.mob)) {
            return false;
        }
        if (!this.mob.f_19862_) {
            return false;
        }
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.mob.m_21573_();
        Path path = groundpathnavigation.m_26570_();
        if (path != null && !path.m_77392_()) {
            for (int i = 0; i < Math.min(path.m_77399_() + 2, path.m_77398_()); ++i) {
                Node node = path.m_77375_(i);
                this.doorPos = new BlockPos(node.f_77271_, node.f_77272_ + 1, node.f_77273_);
                if (this.mob.m_20275_(this.doorPos.m_123341_(), this.mob.m_20186_(), this.doorPos.m_123343_()) > 2.25) continue;
                this.hasDoor = DoorBlock.m_52745_((Level)this.mob.m_9236_(), (BlockPos)this.doorPos);
                if (!this.hasDoor) continue;
                return true;
            }
            this.doorPos = this.mob.m_20183_().m_7494_();
            this.hasDoor = DoorBlock.m_52745_((Level)this.mob.m_9236_(), (BlockPos)this.doorPos);
            return this.hasDoor;
        }
        return false;
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        return !this.passed;
    }

    public void m_8056_() {
        this.passed = false;
        this.doorOpenDirX = (float)((double)this.doorPos.m_123341_() + 0.5 - this.mob.m_20185_());
        this.doorOpenDirZ = (float)((double)this.doorPos.m_123343_() + 0.5 - this.mob.m_20189_());
        if (!this.hasDoor || this.tryToTrigger(this.triggerOpenDoor, () -> this.triggerOpenDoor.activate((Mob)this.mob, this.doorPos))) {
            // empty if block
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        float f1;
        float f = (float)((double)this.doorPos.m_123341_() + 0.5 - this.mob.m_20185_());
        float f2 = this.doorOpenDirX * f + this.doorOpenDirZ * (f1 = (float)((double)this.doorPos.m_123343_() + 0.5 - this.mob.m_20189_()));
        if (f2 < 0.0f) {
            this.passed = true;
        }
    }

    public static void setDoorState(Level level, Entity entity, BlockPos doorPos, boolean open) {
        BlockState blockstate = level.m_8055_(doorPos);
        if (blockstate.m_60734_() instanceof DoorBlock) {
            ((DoorBlock)blockstate.m_60734_()).m_153165_(entity, level, blockstate, doorPos, open);
        }
    }

    public void setTriggerOpenDoor(GoalTrigger.ForMobBlockPos triggerOpenDoor) {
        this.triggerOpenDoor = triggerOpenDoor;
    }
}

