/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;

public class GoalRandomLookAround<T extends BaseAnimal>
extends CustomGoal<T> {
    private LivingEntity target;
    private double relX;
    private double relZ;
    private int lookTime;
    private boolean lookAtMob = false;

    public GoalRandomLookAround(T mob) {
        super(mob);
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.m_217005_()) {
            return false;
        }
        return this.mob.m_217043_().m_188501_() < 0.05f;
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        if (this.mob.m_217005_()) {
            return false;
        }
        return this.lookTime >= 0;
    }

    public void m_8056_() {
        double d0 = Math.PI * 2 * this.mob.m_217043_().m_188500_();
        this.relX = Math.cos(d0);
        this.relZ = Math.sin(d0);
        this.lookTime = 20 + this.mob.m_217043_().m_188503_(20);
        if (RandomUtils.doWithChance((float)50.0f)) {
            this.target = this.mob.m_9236_().m_45963_(LivingEntity.class, TargetingConditions.m_148353_(), (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), this.mob.m_20191_().m_82400_(8.0));
            this.lookAtMob = this.target != null;
        }
    }

    public void m_8041_() {
        this.target = null;
        this.lookAtMob = false;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        --this.lookTime;
        if (this.lookAtMob && this.target != null) {
            this.mob.m_21563_().m_24960_((Entity)this.target, 5.0f, 5.0f);
        } else {
            this.mob.m_21563_().m_24950_(this.mob.m_20185_() + this.relX, this.mob.m_20188_(), this.mob.m_20189_() + this.relZ, 5.0f, 5.0f);
        }
    }

    public static class Builder
    extends CustomGoalFactory {
        public GoalRandomLookAround create(BaseAnimal animal) {
            return new GoalRandomLookAround<BaseAnimal>(animal);
        }
    }
}

