/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import com.google.gson.JsonObject;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.astemir.astemirlib.common.world.WorldUtils;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.ClimberMob;
import ru.xishnikus.thedawnera.common.entity.entity.water.EntityDiplocaulus;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalRandomStroll<T extends BaseAnimal>
extends CustomGoal<T> {
    private PositionChooser positionChooser = PositionChooser.ANY;
    private MovementImplementer movementImplementer = MovementImplementer.MOVE_TO_POINT;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected final double speedModifier;
    protected int interval;
    private int maxHorizontalDistance = 10;
    private int maxVerticalDistance = 7;
    protected boolean forceTrigger;
    private final boolean checkNoActionTime;
    private double groundSpeedMultiplier = 1.0;
    private double underwaterSpeedMupltiplier = 1.0;

    public GoalRandomStroll(T mob, double speedModifier) {
        this(mob, speedModifier, 120);
    }

    public GoalRandomStroll(T mob, double speedModifier, int interval) {
        this(mob, speedModifier, interval, true);
    }

    public GoalRandomStroll(T mob, double speedModifier, int interval, boolean checkNoAction) {
        super(mob);
        this.speedModifier = speedModifier;
        this.interval = interval;
        this.checkNoActionTime = checkNoAction;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Vec3 vec3;
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.m_20160_()) {
            return false;
        }
        if (!this.forceTrigger) {
            if (this.checkNoActionTime && this.mob.m_21216_() >= 100) {
                return false;
            }
            if (this.mob.m_217043_().m_188503_(GoalRandomStroll.m_186073_((int)this.interval)) != 0) {
                return false;
            }
        }
        if ((vec3 = this.getPosition()) == null) {
            return false;
        }
        this.wantedX = vec3.f_82479_;
        this.wantedY = vec3.f_82480_;
        this.wantedZ = vec3.f_82481_;
        this.forceTrigger = false;
        return true;
    }

    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        return !this.mob.m_21573_().m_26571_() && !this.mob.m_20160_();
    }

    public void m_8056_() {
        double finalSpeed = this.mob.m_20069_() ? this.speedModifier * this.underwaterSpeedMupltiplier : this.speedModifier * this.groundSpeedMultiplier;
        this.movementImplementer.implement((PathfinderMob)this.mob, this.mob.m_20182_(), new Vec3(this.wantedX, this.wantedY, this.wantedZ), finalSpeed);
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        super.m_8041_();
    }

    @Nullable
    protected Vec3 getPosition() {
        return this.positionChooser.getPosition((PathfinderMob)this.mob, this.maxHorizontalDistance, this.maxVerticalDistance);
    }

    public void trigger() {
        this.forceTrigger = true;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setPositionChooser(PositionChooser positionChooser) {
        this.positionChooser = positionChooser;
    }

    public void setMovementImplementer(MovementImplementer movementImplementer) {
        this.movementImplementer = movementImplementer;
    }

    public void setDistance(int maxHorizontalDistance, int maxVerticalDistance) {
        this.maxHorizontalDistance = maxHorizontalDistance;
        this.maxVerticalDistance = maxVerticalDistance;
    }

    public void setGroundSpeedMultiplier(double groundSpeedMultiplier) {
        this.groundSpeedMultiplier = groundSpeedMultiplier;
    }

    public void setUnderwaterSpeedMupltiplier(double underwaterSpeedMupltiplier) {
        this.underwaterSpeedMupltiplier = underwaterSpeedMupltiplier;
    }

    public static enum PositionChooser {
        ANY((mob, horizontalDistance, verticalDistance) -> DefaultRandomPos.m_148403_((PathfinderMob)mob, (int)horizontalDistance, (int)verticalDistance)),
        WATER((mob, horizontalDistance, verticalDistance) -> BehaviorUtils.m_147444_((PathfinderMob)mob, (int)horizontalDistance, (int)verticalDistance)),
        WATER_SEA((mob, horizontalDistance, verticalDistance) -> {
            BlockPos around = mob.m_20183_();
            BlockPos.MutableBlockPos move = new BlockPos.MutableBlockPos();
            move.m_122169_(mob.m_20185_(), mob.m_20186_(), mob.m_20189_());
            while (move.m_123342_() < mob.m_9236_().m_151558_() && mob.m_9236_().m_6425_((BlockPos)move).m_205070_(FluidTags.f_13131_)) {
                move.m_122184_(0, 5, 0);
            }
            int surfaceY = move.m_123342_();
            around = around.m_175288_(Math.min(surfaceY - 6, around.m_123342_()));
            for (int i = 0; i < 15; ++i) {
                boolean targetBlocked;
                BlockPos blockPos = around.m_7918_(mob.m_217043_().m_188503_(horizontalDistance) - horizontalDistance / 2, mob.m_217043_().m_188503_(verticalDistance) - verticalDistance / 2, mob.m_217043_().m_188503_(horizontalDistance) - horizontalDistance / 2);
                Vec3 vec3 = new Vec3(mob.m_20185_(), mob.m_20188_(), mob.m_20189_());
                boolean bl = targetBlocked = mob.m_9236_().m_45547_(new ClipContext(vec3, Vec3.m_82512_((Vec3i)blockPos), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mob)).m_6662_() != HitResult.Type.MISS;
                if (!mob.m_9236_().m_6425_(blockPos).m_205070_(FluidTags.f_13131_) || targetBlocked || blockPos.m_123342_() <= mob.m_9236_().m_141937_() + 1) continue;
                return blockPos.m_252807_();
            }
            return around.m_252807_();
        }),
        LAND((mob, horizontalDistance, verticalDistance) -> {
            Vec3 randomPos = DefaultRandomPos.m_148403_((PathfinderMob)mob, (int)horizontalDistance, (int)verticalDistance);
            if (mob.m_20072_()) {
                Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)mob, (int)horizontalDistance, (int)verticalDistance);
                return vec3 == null ? randomPos : vec3;
            }
            return mob.m_217043_().m_188501_() >= 0.001f ? LandRandomPos.m_148488_((PathfinderMob)mob, (int)horizontalDistance, (int)verticalDistance) : randomPos;
        }),
        AMPHIBIAN((mob, horizontalDistance, verticalDistance) -> {
            float f1 = (float)mob.m_20146_() / (float)mob.m_6062_();
            if (!mob.m_20069_()) {
                boolean moistEnough = true;
                if (mob instanceof EntityDiplocaulus) {
                    EntityDiplocaulus diplocaulus = (EntityDiplocaulus)mob;
                    boolean bl = moistEnough = diplocaulus.getMoistnessLevel() > 200;
                }
                if (RandomUtils.doWithChance((float)75.0f) && moistEnough) {
                    return LAND.getPosition(mob, horizontalDistance, verticalDistance);
                }
                Vec3 waterPos = WATER.getPosition(mob, horizontalDistance, verticalDistance);
                if (waterPos == null) {
                    return LAND.getPosition(mob, horizontalDistance, verticalDistance);
                }
            } else {
                if (f1 < 0.5f) {
                    return LAND.getPosition(mob, horizontalDistance, verticalDistance);
                }
                return WATER.getPosition(mob, horizontalDistance, verticalDistance);
            }
            return WATER.getPosition(mob, horizontalDistance, verticalDistance);
        }),
        CLIMB((mob, horizontalDistance, verticalDistance) -> {
            if (mob instanceof ClimberMob) {
                Vec3 pos;
                ClimberMob climberMob = (ClimberMob)mob;
                if (mob.m_217043_().m_188501_() >= 0.5f && (pos = DefaultRandomPos.m_148403_((PathfinderMob)mob, (int)horizontalDistance, (int)verticalDistance)) != null && climberMob.isBlockAttachable(mob.m_9236_().m_8055_(WorldUtils.blockPos((Vec3)pos)))) {
                    return pos;
                }
            }
            return LAND.getPosition(mob, horizontalDistance, verticalDistance);
        });

        private PosFunc function;

        private PositionChooser(PosFunc function) {
            this.function = function;
        }

        public Vec3 getPosition(PathfinderMob mob, int horizontalDistance, int verticalDistance) {
            return this.function.get(mob, horizontalDistance, verticalDistance);
        }

        private static interface PosFunc {
            public Vec3 get(PathfinderMob var1, int var2, int var3);
        }
    }

    public static enum MovementImplementer {
        MOVE_TO_POINT((mob, from, to, speedModifier) -> mob.m_21573_().m_26519_(to.f_82479_, to.f_82480_, to.f_82481_, speedModifier)),
        SQUID_DASH((mob, from, to, speedModifier) -> {
            Vec3 vec = mob.m_20184_().m_82549_(AVector3f.from((Vec3)from).direction(AVector3f.from((Vec3)to).add(0.0f, MathUtils.sin((float)mob.f_19797_), 0.0f)).toVec3().m_82490_((double)0.3f));
            float xRot = (float)(Mth.m_14136_((double)vec.f_82480_, (double)vec.m_165924_()) * 57.2957763671875);
            mob.m_146922_(MathUtils.deg((float)((float)Mth.m_14136_((double)(-vec.f_82479_), (double)vec.f_82481_))));
            mob.m_146926_(-xRot);
            mob.m_20256_(vec.m_82490_((double)0.6f));
            mob.m_21573_().m_26519_(to.f_82479_, to.f_82480_, to.f_82481_, speedModifier);
        });

        private MoveFunc moveFunc;

        private MovementImplementer(MoveFunc moveFunc) {
            this.moveFunc = moveFunc;
        }

        public void implement(PathfinderMob mob, Vec3 from, Vec3 to, double speedModifier) {
            this.moveFunc.moveTo(mob, from, to, speedModifier);
        }

        private static interface MoveFunc {
            public void moveTo(PathfinderMob var1, Vec3 var2, Vec3 var3, double var4);
        }
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="Speed")
        private NumberProperty speedModifier = NumberProperty.uniform(1.0);
        @JsonField(value="Interval")
        private NumberProperty interval = NumberProperty.uniform(120.0);
        @JsonField(value="MaxHorizontalDistance")
        private NumberProperty maxHorizontalDistance = NumberProperty.uniform(10.0);
        @JsonField(value="MaxVerticalDistance")
        private NumberProperty maxVerticalDistance = NumberProperty.uniform(7.0);
        @JsonField(value="WaterSpeedMultiplier")
        private NumberProperty waterSpeedMultiplier = NumberProperty.uniform(1.0);
        @JsonField(value="GroundSpeedMultiplier")
        private NumberProperty groundSpeedMultiplier = NumberProperty.uniform(1.0);
        private PositionChooser positionChooser = PositionChooser.ANY;
        private MovementImplementer movementImplementer = MovementImplementer.MOVE_TO_POINT;

        public GoalRandomStroll create(BaseAnimal animal) {
            GoalRandomStroll<BaseAnimal> goal = new GoalRandomStroll<BaseAnimal>(animal, this.speedModifier.getDouble(), this.interval.getInt(), true);
            goal.setPositionChooser(this.positionChooser);
            goal.setDistance(this.maxHorizontalDistance.getInt(), this.maxVerticalDistance.getInt());
            goal.setGroundSpeedMultiplier(this.groundSpeedMultiplier.getDouble());
            goal.setUnderwaterSpeedMupltiplier(this.waterSpeedMultiplier.getDouble());
            goal.setMovementImplementer(this.movementImplementer);
            return goal;
        }

        @Override
        public void deserialize(JsonObject json) {
            if (json.has("PositionChooser")) {
                this.positionChooser = PositionChooser.valueOf(json.get("PositionChooser").getAsString().toUpperCase());
            }
            if (json.has("MovementImplementer")) {
                this.movementImplementer = MovementImplementer.valueOf(json.get("MovementImplementer").getAsString().toUpperCase());
            }
        }
    }
}

