/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import ru.xishnikus.thedawnera.common.entity.ai.goal.move.GoalMoveToEntity;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.predicate.ItemPredicate;

public class GoalTemptByItem<T extends BaseAnimal>
extends GoalMoveToEntity<T> {
    public GoalTemptByItem(T mob, double speedModifier, int searchRange, int verticalSearchRange, int randomTick, BiPredicate<BaseAnimal, ItemStack> predicate) {
        super(mob, speedModifier, searchRange, verticalSearchRange, randomTick, (Entity e) -> {
            if (e instanceof Player) {
                Player player = (Player)e;
                return predicate.test((BaseAnimal)((Object)mob), player.m_21205_()) || predicate.test((BaseAnimal)((Object)mob), player.m_21206_());
            }
            return false;
        });
    }

    public static class Builder
    extends GoalMoveToEntity.Builder {
        private BiPredicate<BaseAnimal, ItemStack> itemConditions = (mob, item) -> true;

        @Override
        public GoalTemptByItem create(BaseAnimal animal) {
            return new GoalTemptByItem<BaseAnimal>(animal, this.speedModifier.getDouble(), this.horizontalDistance.getInt(), this.verticalDistance.getInt(), this.interval.getInt(), this.itemConditions);
        }

        @Override
        public void deserialize(JsonObject json) {
            if (json.has("Items")) {
                List<ItemPredicate> items = ItemPredicate.parseItems(json, "Items");
                this.itemConditions = (mob, itemStack) -> {
                    if (itemStack != null) {
                        for (ItemPredicate item : items) {
                            if (!item.test((LivingEntity)mob, (ItemStack)itemStack)) continue;
                            return true;
                        }
                    }
                    return false;
                };
            } else {
                this.itemConditions = (mob, itemStack) -> mob.getMobRation().canBeEaten((LivingEntity)mob, (ItemStack)itemStack);
            }
        }
    }
}

