/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.move;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class GoalTryToFindAir<T extends BaseAnimal>
extends CustomGoal<T> {
    private int minAir;
    private double speedModifier;

    public GoalTryToFindAir(T mob, double speedModifier, int minAir) {
        super(mob);
        this.speedModifier = speedModifier;
        this.minAir = minAir;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.mob.m_20146_() < this.minAir;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        this.findAirPosition();
    }

    private void findAirPosition() {
        Iterable iterable = BlockPos.m_121976_((int)Mth.m_14107_((double)(this.mob.m_20185_() - 1.0)), (int)this.mob.m_146904_(), (int)Mth.m_14107_((double)(this.mob.m_20189_() - 1.0)), (int)Mth.m_14107_((double)(this.mob.m_20185_() + 1.0)), (int)Mth.m_14107_((double)(this.mob.m_20186_() + 8.0)), (int)Mth.m_14107_((double)(this.mob.m_20189_() + 1.0)));
        BlockPos blockpos = null;
        for (BlockPos blockpos1 : iterable) {
            if (!this.givesAir((LevelReader)this.mob.m_9236_(), blockpos1)) continue;
            blockpos = blockpos1;
            break;
        }
        if (blockpos == null) {
            blockpos = BlockPos.m_274561_((double)this.mob.m_20185_(), (double)(this.mob.m_20186_() + 8.0), (double)this.mob.m_20189_());
        }
        this.mob.m_21563_().m_24946_((double)blockpos.m_123341_(), (double)(blockpos.m_123342_() + 1), (double)blockpos.m_123343_());
    }

    public void m_8037_() {
        this.findAirPosition();
        AVector3f dir = EntityUtils.getDirection((Entity)this.mob);
        this.mob.m_6478_(MoverType.SELF, dir.toVec3().m_82542_(0.25, (double)0.33f, 0.25).m_82542_(this.speedModifier, this.speedModifier, this.speedModifier));
    }

    private boolean givesAir(LevelReader levelReader, BlockPos blockPos) {
        BlockState blockstate = levelReader.m_8055_(blockPos);
        return (levelReader.m_6425_(blockPos).m_76178_() || blockstate.m_60713_(Blocks.f_50628_)) && blockstate.m_60647_((BlockGetter)levelReader, blockPos, PathComputationType.LAND);
    }

    public static class Builder
    extends CustomGoalFactory {
        @JsonField(value="Speed")
        private NumberProperty speedModifier = NumberProperty.uniform(1.0);
        @JsonField(value="MinAir")
        private NumberProperty minAir = NumberProperty.uniform(150.0);

        public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            return new GoalTryToFindAir<BaseAnimal>(animal, this.speedModifier.getDouble(), this.minAir.getInt());
        }
    }
}

