/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.target;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomTargetGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;

public class TargetGoalAttack<T extends BaseAnimal>
extends CustomTargetGoal<T> {
    protected TargetingConditions targetConditions;
    protected final int randomInterval;
    protected boolean spatial = false;
    protected double distanceLimit = -1.0;

    public TargetGoalAttack(T mob, int interval, boolean mustSee, boolean mustReach, Predicate<LivingEntity> p_26058_) {
        super(mob, mustSee, mustReach);
        this.randomInterval = TargetGoalAttack.m_186073_((int)interval);
        this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.getFollowDistance()).m_26888_(p_26058_);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    @Override
    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.randomInterval > 0 && this.mob.m_217043_().m_188503_(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        return this.targetMob != null;
    }

    protected AABB getTargetSearchArea(double radius) {
        return this.mob.m_20191_().m_82377_(radius, this.spatial ? radius : 4.0, radius);
    }

    protected void findTarget() {
        LivingEntity potentialTarget = this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(LivingEntity.class, this.getTargetSearchArea(this.getFollowDistance()), target -> !this.mob.isTamed() || this.mob.m_6779_((LivingEntity)target)), this.targetConditions, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
        if (potentialTarget != null) {
            this.targetFoundDistanceIgnored(potentialTarget);
            if (this.distanceLimit != -1.0 && this.mob.m_20280_((Entity)potentialTarget) > this.distanceLimit * this.distanceLimit) {
                return;
            }
        }
        this.targetMob = potentialTarget;
    }

    @Override
    public void m_8056_() {
        if (this.targetMob != null) {
            this.mob.m_6710_(this.targetMob);
        }
        super.m_8056_();
    }

    public void setTarget(LivingEntity target) {
        this.targetMob = target;
    }

    protected void targetFoundDistanceIgnored(LivingEntity target) {
    }

    public void setDistanceLimit(double distanceLimit) {
        this.distanceLimit = distanceLimit;
    }

    public void spatialSearch() {
        this.spatial = true;
    }
}

