/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.target;

import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomTargetGoal;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomTargetGoalFactory;

public class TargetGoalDefendBaby<T extends BaseAnimal>
extends CustomTargetGoal<T> {
    private TargetingConditions targetConditions = TargetingConditions.m_148352_().m_26888_(e -> !e.m_6162_()).m_26883_(this.getFollowDistance());

    public TargetGoalDefendBaby(T mob) {
        super(mob, true);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    @Override
    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.isTamed()) {
            return false;
        }
        if (this.mob.m_6162_()) {
            return false;
        }
        if (!this.mob.hasBaby()) {
            this.mob.setParentOfBaby(this.mob.getNearestBaby(8.0f, 4.0f, 8.0f));
        }
        if (this.mob.isTamed() && this.mob.getBehaviourType() == MobOrder.Behaviour.PASSIVE) {
            return false;
        }
        this.findTarget();
        if (this.mob.hasBaby() && this.targetMob != null) {
            return this.mob.m_6779_(this.targetMob);
        }
        return false;
    }

    @Override
    public void m_8056_() {
        this.mob.m_6710_(this.targetMob);
        this.targetMob = this.mob.m_5448_();
        this.unseenMemoryTicks = 300;
        super.m_8056_();
    }

    protected AABB getTargetSearchArea(double p_26069_) {
        return this.mob.m_20191_().m_82377_(p_26069_, 4.0, p_26069_);
    }

    protected void findTarget() {
        this.targetMob = this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(LivingEntity.class, this.getTargetSearchArea(4.0), entity -> {
            if (this.mob.isTamed() && !this.mob.m_6779_(this.targetMob)) {
                return false;
            }
            return entity.getClass() != ((Object)((Object)this.mob)).getClass();
        }), this.targetConditions, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
    }

    public static class Builder
    extends CustomTargetGoalFactory {
        @Override
        public CustomTargetGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            return new TargetGoalDefendBaby<BaseAnimal>(animal);
        }
    }
}

