/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.target;

import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomTargetGoal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.GoalTrigger;
import ru.xishnikus.thedawnera.common.entity.ai.goal.target.TargetGoalAttack;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomTargetGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobCondition;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;
import ru.xishnikus.thedawnera.common.utils.TDEPredicates;

public class TargetGoalGuardTerritory<T extends BaseAnimal>
extends TargetGoalAttack<T> {
    private double awareDistance;
    private int tickLimit = 0;
    private boolean awareOwnSpecies = false;
    private GoalTrigger.ForMobTarget triggerAware;

    public TargetGoalGuardTerritory(T mob, double awareDistance, double canAttackDistance, int interval, Predicate<LivingEntity> predicate, boolean mustSee, boolean mustReach) {
        super(mob, interval, mustSee, mustReach, predicate);
        this.awareDistance = awareDistance;
        this.distanceLimit = canAttackDistance;
    }

    @Override
    protected void targetFoundDistanceIgnored(LivingEntity target) {
        if (this.tickLimit > 0) {
            --this.tickLimit;
        } else if (target.m_20280_((Entity)this.mob) > this.distanceLimit * this.distanceLimit && target.m_20280_((Entity)this.mob) <= this.awareDistance * this.awareDistance) {
            this.tickLimit = this.m_183277_(10);
            this.tryToTrigger(this.triggerAware, () -> this.triggerAware.activate((Mob)this.mob, (Entity)target));
        }
    }

    @Override
    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.randomInterval > 0 && this.mob.m_217043_().m_188503_(this.randomInterval) != 0) {
            return false;
        }
        if (this.mob.isTamed()) {
            return false;
        }
        if (this.mob.m_5448_() != null) {
            return false;
        }
        this.findTarget();
        if (this.mob.m_6779_(this.targetMob) && this.targetMob != null) {
            return !TDEPredicates.isSameSpecies((LivingEntity)this.mob).test(this.targetMob) || this.awareOwnSpecies;
        }
        return false;
    }

    @Override
    public boolean m_8045_() {
        if (!this.isCanBeContinuedToUse()) {
            return false;
        }
        if (!super.m_8045_()) {
            return false;
        }
        if (this.mob.m_5448_() != null) {
            return false;
        }
        if (this.mob.isTamed()) {
            return false;
        }
        return this.mob.m_6779_(this.targetMob);
    }

    @Override
    protected void findTarget() {
        LivingEntity potentialTarget = this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(LivingEntity.class, this.getTargetSearchArea(this.getFollowDistance()), target -> {
            if (this.mob.isTamed()) {
                return false;
            }
            if (TDEPredicates.isSameSpecies((LivingEntity)this.mob).test((LivingEntity)target) && !this.awareOwnSpecies) {
                return false;
            }
            return this.mob.m_6779_((LivingEntity)target);
        }), this.targetConditions, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
        if (potentialTarget != null) {
            this.targetFoundDistanceIgnored(potentialTarget);
            if (this.distanceLimit != -1.0 && this.mob.m_20280_((Entity)potentialTarget) > this.distanceLimit * this.distanceLimit) {
                return;
            }
        }
        this.targetMob = potentialTarget;
    }

    @Override
    public void m_8041_() {
        this.targetMob = null;
    }

    public void setTriggerAware(GoalTrigger.ForMobTarget triggerAware) {
        this.triggerAware = triggerAware;
    }

    public void setAwareOwnSpecies(boolean awareOwnSpecies) {
        this.awareOwnSpecies = awareOwnSpecies;
    }

    public static class Builder
    extends CustomTargetGoalFactory {
        @JsonField(value="AwareDistance")
        private NumberProperty awareDistance = NumberProperty.uniform(10.0);
        @JsonField(value="CanAttackDistance")
        private NumberProperty canAttackDistance = NumberProperty.uniform(5.0);
        @JsonField(value="Interval")
        private NumberProperty interval = NumberProperty.uniform(10.0);
        @JsonField(value="AwareOwnSpecies")
        private boolean awareOwnSpecies = false;
        private Predicate<LivingEntity> targetConditions = target -> true;
        private GoalTrigger.ForMobTarget aware;

        @Override
        public CustomTargetGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            TargetGoalGuardTerritory<BaseAnimal> goal = new TargetGoalGuardTerritory<BaseAnimal>(animal, this.awareDistance.getDouble(), this.canAttackDistance.getDouble(), this.interval.getInt(), this.targetConditions, this.mustSee, this.mustReach);
            goal.setTriggerAware(this.aware);
            goal.setAwareOwnSpecies(this.awareOwnSpecies);
            return goal;
        }

        @Override
        public void deserialize(JsonObject json) {
            if (json.has("TargetConditions")) {
                this.targetConditions = MobCondition.parsePredicate(LivingEntity.class, json, "TargetConditions");
            }
            if (json.has("TryToAware")) {
                this.aware = GoalTrigger.ForMobTarget.fromJson(json, "TryToAware");
            }
        }
    }
}

