/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.target;

import net.minecraft.world.entity.LivingEntity;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomTargetGoal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.target.TargetGoalAttack;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomTargetGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class TargetGoalHunt<T extends BaseAnimal>
extends TargetGoalAttack<T> {
    public TargetGoalHunt(T mob, int interval, boolean mustSee, boolean mustReach) {
        super(mob, interval, mustSee, mustReach, livingEntity -> mob.getMobRation().canBeEaten((LivingEntity)mob, (LivingEntity)livingEntity));
    }

    @Override
    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (!this.mob.isTamed() ? !this.mob.isHungry() : this.mob.getMovementOrderType() == MobOrder.Movement.WAIT || this.mob.getBehaviourType() != MobOrder.Behaviour.AGGRESSIVE) {
            return false;
        }
        return super.m_8036_() && this.mob.m_6779_(this.targetMob);
    }

    @Override
    public boolean m_8045_() {
        if (!super.m_8045_()) {
            return false;
        }
        if (!this.mob.isTamed() ? !this.mob.isHungry() : this.mob.getMovementOrderType() == MobOrder.Movement.WAIT || this.mob.getBehaviourType() != MobOrder.Behaviour.AGGRESSIVE) {
            return false;
        }
        return this.mob.m_6779_(this.targetMob);
    }

    public static class Builder
    extends CustomTargetGoalFactory {
        @JsonField(value="Interval")
        private NumberProperty interval = NumberProperty.uniform(10.0);
        @JsonField(value="SpatialSearch")
        private boolean spatialSearch = false;

        @Override
        public CustomTargetGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            TargetGoalHunt<BaseAnimal> goal = new TargetGoalHunt<BaseAnimal>(animal, this.interval.getInt(), this.mustReach, this.mustSee);
            if (this.spatialSearch) {
                goal.spatialSearch();
            }
            return goal;
        }
    }
}

