/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.target;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomTargetGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomTargetGoalFactory;
import ru.xishnikus.thedawnera.common.io.json.JsonField;

public class TargetGoalHurtRevenge<T extends BaseAnimal>
extends CustomTargetGoal<T> {
    private static final TargetingConditions HURT_BY_TARGETING = TargetingConditions.m_148352_().m_148355_().m_26893_();
    private boolean alertSameType;
    private int timestamp;
    private final Class<?>[] toIgnoreDamage;
    private Class<?>[] toIgnoreAlert;

    public TargetGoalHurtRevenge(T mob, Class<?> ... ignoreEntityClasses) {
        super(mob, true);
        this.toIgnoreDamage = ignoreEntityClasses;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    @Override
    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        int i = this.mob.m_21213_();
        LivingEntity livingentity = this.mob.m_21188_();
        if (i != this.timestamp && livingentity != null) {
            if (livingentity.m_6095_() == EntityType.f_20532_ && this.mob.m_9236_().m_46469_().m_46207_(GameRules.f_46127_)) {
                return false;
            }
            for (Class<?> oclass : this.toIgnoreDamage) {
                if (!oclass.isAssignableFrom(livingentity.getClass())) continue;
                return false;
            }
            return this.canAttack(livingentity, HURT_BY_TARGETING);
        }
        return false;
    }

    @Override
    public void m_8056_() {
        this.mob.m_6710_(this.mob.m_21188_());
        this.targetMob = this.mob.m_5448_();
        this.timestamp = this.mob.m_21213_();
        this.unseenMemoryTicks = 300;
        if (this.alertSameType) {
            this.alertOthers();
        }
        super.m_8056_();
    }

    protected void alertOthers() {
        double d0 = this.getFollowDistance();
        AABB aabb = AABB.m_82333_((Vec3)this.mob.m_20182_()).m_82377_(d0, 10.0, d0);
        List list = this.mob.m_9236_().m_6443_(((Object)((Object)this.mob)).getClass(), aabb, EntitySelector.f_20408_);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Mob mob = (Mob)iterator.next();
            if (this.mob == mob || mob.m_5448_() != null || mob.m_7307_((Entity)this.mob.m_21188_())) continue;
            if (this.toIgnoreAlert != null) {
                boolean flag = false;
                for (Class<?> oclass : this.toIgnoreAlert) {
                    if (mob.getClass() != oclass) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
            }
            this.alertOther(mob, this.mob.m_21188_());
        }
        return;
    }

    protected void alertOther(Mob mob, LivingEntity target) {
        if (mob instanceof BaseAnimal) {
            BaseAnimal baseAnimal = (BaseAnimal)mob;
            if (baseAnimal.m_6779_(target)) {
                mob.m_6710_(target);
            }
        } else {
            mob.m_6710_(target);
        }
    }

    public void setAlertOthers(Class<?> ... toIgnoreDamage) {
        this.alertSameType = true;
        this.toIgnoreAlert = toIgnoreDamage;
    }

    public static class Builder
    extends CustomTargetGoalFactory {
        @JsonField(value="AlertOthers")
        private boolean alertOthers = false;

        @Override
        public CustomTargetGoal<? extends BaseAnimal> create(BaseAnimal animal) {
            TargetGoalHurtRevenge<BaseAnimal> goal = new TargetGoalHurtRevenge<BaseAnimal>(animal, new Class[0]);
            if (this.alertOthers) {
                goal.setAlertOthers(new Class[0]);
            }
            return goal;
        }
    }
}

