/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.ai.goal.target;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomTargetGoal;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomTargetGoalFactory;

public class TargetGoalOwner<T extends BaseAnimal>
extends CustomTargetGoal<T> {
    private LivingEntity ownerLastHurt;
    private int timestamp;

    public TargetGoalOwner(T mob) {
        super(mob, false);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    @Override
    public boolean m_8036_() {
        if (!this.isCanBeUsed()) {
            return false;
        }
        if (this.mob.isTamed() && this.mob.getMovementOrderType() != MobOrder.Movement.WAIT && this.mob.getBehaviourType() != MobOrder.Behaviour.IGNORE) {
            LivingEntity livingentity = this.mob.m_269323_();
            if (livingentity == null) {
                return false;
            }
            if (this.mob.m_6779_(livingentity.m_21214_())) {
                this.ownerLastHurt = livingentity.m_21214_();
                int i = livingentity.m_21215_();
                return i != this.timestamp && this.canAttack(this.ownerLastHurt, TargetingConditions.f_26872_) && this.mob.m_6779_(this.ownerLastHurt);
            }
        }
        return false;
    }

    @Override
    public void m_8056_() {
        this.mob.m_6710_(this.ownerLastHurt);
        LivingEntity livingentity = this.mob.m_269323_();
        if (livingentity != null) {
            this.timestamp = livingentity.m_21215_();
        }
        super.m_8056_();
    }

    public static class Builder
    extends CustomTargetGoalFactory {
        private Predicate<Entity> condition = entity -> true;

        @Override
        public TargetGoalOwner create(BaseAnimal animal) {
            TargetGoalOwner<BaseAnimal> goal = new TargetGoalOwner<BaseAnimal>(animal);
            goal.setCanTargetCondition(this.condition);
            return goal;
        }
    }
}

