/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.data;

import com.google.common.reflect.Reflection;
import java.util.LinkedHashSet;
import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.utils.TDEUtils;

public interface MobOrder {
    public static final LinkedHashSet<MobOrder> REGISTRY = new LinkedHashSet();

    public static int register(MobOrder action) {
        int id = REGISTRY.size();
        REGISTRY.add(action);
        return id;
    }

    public static void init() {
        Reflection.initialize((Class[])new Class[]{MobOrder.class, Behaviour.class, Eating.class, Accessibility.class, PlayerClick.class, Movement.class, Specific.class});
    }

    public static MobOrder fromId(int id) {
        for (MobOrder mobSpecialAction : REGISTRY) {
            if (mobSpecialAction.getId() != id) continue;
            return mobSpecialAction;
        }
        throw new IllegalStateException("Invalid mob data");
    }

    public String getName();

    public String getType();

    public String getMessage();

    public int getId();

    default public boolean isMovement() {
        return this instanceof Movement;
    }

    default public boolean isEating() {
        return this instanceof Eating;
    }

    default public boolean isAccessibility() {
        return this instanceof Accessibility;
    }

    default public boolean isBehaviour() {
        return this instanceof Behaviour;
    }

    default public boolean isSpecific() {
        return this instanceof Specific;
    }

    default public boolean isAction() {
        return this instanceof PlayerClick;
    }

    default public Movement movementOrder() {
        return (Movement)this;
    }

    default public Eating foodOrder() {
        return (Eating)this;
    }

    default public Accessibility accessibility() {
        return (Accessibility)this;
    }

    default public Behaviour behaviour() {
        return (Behaviour)this;
    }

    default public PlayerClick action() {
        return (PlayerClick)this;
    }

    default public Specific specific() {
        return (Specific)this;
    }

    public static enum Behaviour implements MobOrder
    {
        AGGRESSIVE("behaviour.dawnera.aggressive", "msg.dawnera.behaviour.aggressive"),
        PASSIVE("behaviour.dawnera.passive", "msg.dawnera.behaviour.passive"),
        IGNORE("behaviour.dawnera.ignore", "msg.dawnera.behaviour.ignore");

        public static final String TYPE_ID = "order.dawnera.behaviour";
        private int id;
        private String name;
        private String message;

        private Behaviour(String name, String message) {
            this.name = name;
            this.message = message;
            this.id = MobOrder.register(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return TYPE_ID;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum Eating implements MobOrder
    {
        ALLOW_EAT("eating.dawnera.allow_eat", "msg.dawnera.order.allow_eat"),
        DENY_EAT("eating.dawnera.deny_eat", "msg.dawnera.order.deny_eat");

        public static final String TYPE_ID = "order.dawnera.eating";
        private int id;
        private String name;
        private String message;

        private Eating(String name, String message) {
            this.name = name;
            this.message = message;
            this.id = MobOrder.register(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return TYPE_ID;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum Accessibility implements MobOrder
    {
        PRIVATE("accessibility.dawnera.private", "msg.dawnera.order.private"),
        PUBLIC("accessibility.dawnera.public", "msg.dawnera.order.public");

        public static final String TYPE_ID = "order.dawnera.accessibility";
        private int id;
        private String name;
        private String message;

        private Accessibility(String name, String message) {
            this.name = name;
            this.message = message;
            this.id = MobOrder.register(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return TYPE_ID;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum PlayerClick implements MobOrder
    {
        INVENTORY("action.dawnera.inventory", (player, livingEntity) -> TDEUtils.openDinoInventory(livingEntity, (ServerPlayer)player));

        private int id;
        private String name;
        private BiConsumer<Player, BaseAnimal> action;

        private PlayerClick(String name, BiConsumer<Player, BaseAnimal> action) {
            this.name = name;
            this.action = action;
            this.id = MobOrder.register(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return null;
        }

        @Override
        public String getMessage() {
            return null;
        }

        public BiConsumer<Player, BaseAnimal> getAction() {
            return this.action;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static enum Movement implements MobOrder
    {
        WAIT("movement.dawnera.wait", "msg.dawnera.order.wait"),
        FOLLOW("movement.dawnera.follow", "msg.dawnera.order.follow"),
        WANDER("movement.dawnera.wander", "msg.dawnera.order.wander");

        public static final String TYPE_ID = "order.dawnera.movement";
        private int id;
        private String name;
        private String message;

        private Movement(String name, String message) {
            this.name = name;
            this.message = message;
            this.id = MobOrder.register(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return TYPE_ID;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static class Specific
    implements MobOrder {
        public static final Specific NO_ORDER = new Specific("order.dawnera.no_order", "msg.dawnera.order.no_order");
        public static final Specific GATHERING = new Specific("order.dawnera.gathering", "msg.dawnera.order.gathering");
        public static final String TYPE_ID = "order.dawnera.specific";
        private String name;
        private String message;
        private int id;

        public Specific(String name, String message) {
            this.name = name;
            this.message = message;
            this.id = MobOrder.register(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return TYPE_ID;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public int getId() {
            return this.id;
        }

        public static Specific[] values() {
            return new Specific[]{NO_ORDER, GATHERING};
        }
    }
}

