/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.client.SmoothValue;
import ru.astemir.astemirlib.client.bedrock.animation.Animated;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.common.action.ActionController;
import ru.astemir.astemirlib.common.action.ActionListener;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.action.ActionStateMachine;
import ru.astemir.astemirlib.common.entity.MobLookLockable;
import ru.astemir.astemirlib.common.handler.EventEntity;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.TDELevelEvents;
import ru.xishnikus.thedawnera.common.entity.ai.controller.GroundPathNavigatorNoSpin;
import ru.xishnikus.thedawnera.common.entity.ai.controller.TDELookControl;
import ru.xishnikus.thedawnera.common.entity.data.GenderType;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.data.MobVariation;
import ru.xishnikus.thedawnera.common.entity.data.TDEEntityDataSerializers;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseRideableAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSleepingAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.MultipartMob;
import ru.xishnikus.thedawnera.common.entity.entity.misc.EntityFallingTree;
import ru.xishnikus.thedawnera.common.entity.misc.RandomRunnable;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.entity.properties.TDEMobProperties;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobFoodRation;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobTameMethod;
import ru.xishnikus.thedawnera.common.io.config.TDECommonConfig;
import ru.xishnikus.thedawnera.common.item.ItemDinoArmor;
import ru.xishnikus.thedawnera.common.item.ItemDinoSaddle;
import ru.xishnikus.thedawnera.common.misc.TDEAttributes;
import ru.xishnikus.thedawnera.common.misc.TDETags;
import ru.xishnikus.thedawnera.common.utils.AttributeUtils;
import ru.xishnikus.thedawnera.common.utils.TDEUtils;

public abstract class BaseAnimal<T extends MobProperties>
extends TamableAnimal
implements Animated,
ActionListener,
EventEntity,
MobLookLockable,
ContainerListener,
HasCustomInventoryScreen {
    public static final String TAME_MESSAGE = "msg.dawnera.tame";
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    protected static final EntityDataAccessor<Boolean> DATA_TAMED;
    protected static final EntityDataAccessor<Boolean> DATA_SADDLED;
    protected static final EntityDataAccessor<Boolean> DATA_PREGNANT;
    protected static final EntityDataAccessor<Float> DATA_HUNGER;
    protected static final EntityDataAccessor<Float> DATA_STAMINA;
    protected static final EntityDataAccessor<Integer> DATA_AGE_IN_TICKS;
    protected static final EntityDataAccessor<GenderType> DATA_GENDER_TYPE;
    protected static final EntityDataAccessor<MobOrder.Movement> DATA_MOVEMENT_ORDER_TYPE;
    protected static final EntityDataAccessor<MobOrder.Eating> DATA_FOOD_ORDER_TYPE;
    protected static final EntityDataAccessor<MobOrder.Accessibility> DATA_ACCESSIBILITY;
    protected static final EntityDataAccessor<MobOrder.Behaviour> DATA_BEHAVIOUR_TYPE;
    protected static final EntityDataAccessor<MobOrder.Specific> DATA_SPECIFIC_ORDER_TYPE;
    protected static final EntityDataAccessor<MobVariation> DATA_VARIATION;
    private MobOrder.Specific[] specificOrders = new MobOrder.Specific[0];
    private SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;
    private T properties;
    protected ActionStateMachine stateMachine;
    public ActionController actionController;
    public ActionController stateController;
    private LivingEntity lastAttackTarget;
    private ItemStack lastEatenFood;
    private BaseAnimal baby;
    @OnlyIn(value=Dist.CLIENT)
    private Animator animator;
    private PartEntity<?>[] parts;
    public SmoothValue<Double> bodyRotDeviation = SmoothValue.valDouble((InterpolationType)InterpolationType.CATMULLROM, (double)0.0);
    public SmoothValue<Double> xRotDeviation = SmoothValue.valDouble((InterpolationType)InterpolationType.CATMULLROM, (double)0.0);
    private final RandomRunnable randomStarve = new RandomRunnable(200, 10.0f){

        @Override
        public void run() {
            float hunger = BaseAnimal.this.getHunger();
            if (hunger > 0.0f) {
                BaseAnimal.this.setHunger(hunger - 1.0f);
            }
        }
    };
    protected int energyBlockTime;
    protected int tickControlled;

    public BaseAnimal(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        BaseAnimal baseAnimal;
        this.properties = TDEMobProperties.getResource(ForgeRegistries.ENTITY_TYPES.getKey(type));
        this.stateMachine = ((MobProperties)this.properties).buildStateMachine(this);
        this.actionController = this.getActionStateMachine().getController("ActionController");
        this.stateController = this.getActionStateMachine().getController("StateController");
        this.inventory = this.createInventory();
        this.f_21342_ = new MoveControl((Mob)this);
        this.f_21365_ = new TDELookControl<BaseAnimal>(this);
        this.addSpecificOrders(MobOrder.Specific.NO_ORDER);
        if (level != null && !level.f_46443_ && ((MobProperties)this.properties).getMobAI() != null) {
            ((MobProperties)this.properties).getMobAI().build(this);
        }
        if ((baseAnimal = this) instanceof MultipartMob) {
            MultipartMob mob = (MultipartMob)((Object)baseAnimal);
            this.parts = mob.initializeParts();
            this.m_20234_(f_19843_.getAndAdd(this.getParts().length + 1) + 1);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType type, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compoundTag) {
        this.randomGender(this.m_217043_());
        this.setHunger(this.getMaxHunger() / 2.0f);
        return super.m_6518_(level, difficultyInstance, type, groupData, compoundTag);
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        if (this instanceof MultipartMob) {
            for (int i = 0; i < this.getParts().length; ++i) {
                this.getParts()[i].m_20234_(id + i + 1);
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_AGE_IN_TICKS, (Object)0);
        this.f_19804_.m_135372_(DATA_TAMED, (Object)false);
        this.f_19804_.m_135372_(DATA_SADDLED, (Object)false);
        this.f_19804_.m_135372_(DATA_HUNGER, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_STAMINA, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_PREGNANT, (Object)false);
        this.f_19804_.m_135372_(DATA_GENDER_TYPE, (Object)GenderType.MALE);
        this.f_19804_.m_135372_(DATA_BEHAVIOUR_TYPE, (Object)MobOrder.Behaviour.AGGRESSIVE);
        this.f_19804_.m_135372_(DATA_MOVEMENT_ORDER_TYPE, (Object)MobOrder.Movement.FOLLOW);
        this.f_19804_.m_135372_(DATA_FOOD_ORDER_TYPE, (Object)MobOrder.Eating.ALLOW_EAT);
        this.f_19804_.m_135372_(DATA_ACCESSIBILITY, (Object)MobOrder.Accessibility.PRIVATE);
        this.f_19804_.m_135372_(DATA_SPECIFIC_ORDER_TYPE, (Object)MobOrder.Specific.NO_ORDER);
        this.f_19804_.m_135372_(DATA_VARIATION, (Object)MobVariation.DEFAULT);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.writeBaseMob(compoundTag);
    }

    protected void writeBaseMob(CompoundTag compoundTag) {
        if (this.m_21805_() != null) {
            compoundTag.m_128362_("Owner", this.m_21805_());
        }
        compoundTag.m_128359_("Gender", this.getGender().toString());
        compoundTag.m_128405_("MovementOrder", this.getMovementOrderType().getId());
        compoundTag.m_128405_("FoodOrder", this.getFoodOrderType().getId());
        compoundTag.m_128405_("AccessibilityOrder", this.getAccessibility().getId());
        compoundTag.m_128405_("BehaviourOrder", this.getBehaviourType().getId());
        compoundTag.m_128405_("SpecificOrder", this.getSpecificOrderType().getId());
        compoundTag.m_128359_("Variation", this.getVariation().toString());
        compoundTag.m_128350_("Hunger", this.getHunger());
        compoundTag.m_128350_("Stamina", this.getEnergy());
        compoundTag.m_128379_("IsPregnant", this.isPregnant());
        if (!this.inventory.m_8020_(0).m_41619_()) {
            compoundTag.m_128365_("SaddleItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(1).m_41619_()) {
            compoundTag.m_128365_("ArmorItem", (Tag)this.inventory.m_8020_(1).m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.readBaseMob(compoundTag);
        this.updateContainerEquipment();
        this.updateAttributes(false);
    }

    protected void readBaseMob(CompoundTag compoundTag) {
        ItemStack itemstack;
        MobOrder order;
        UUID uuid;
        if (compoundTag.m_128403_("Owner")) {
            uuid = compoundTag.m_128342_("Owner");
        } else {
            String s = compoundTag.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.m_21816_(uuid);
                this.setTamed(true);
            }
            catch (Throwable throwable) {
                this.setTamed(false);
            }
        }
        if (compoundTag.m_128441_("Gender")) {
            this.setGender(GenderType.valueOf(compoundTag.m_128461_("Gender").toUpperCase()));
        }
        if (compoundTag.m_128441_("MovementOrder") && (order = MobOrder.fromId(compoundTag.m_128451_("MovementOrder"))).isMovement()) {
            this.setMovementOrderType(order.movementOrder());
        }
        if (compoundTag.m_128441_("FoodOrder") && (order = MobOrder.fromId(compoundTag.m_128451_("FoodOrder"))).isEating()) {
            this.setFoodOrderType(order.foodOrder());
        }
        if (compoundTag.m_128441_("AccessibilityOrder") && (order = MobOrder.fromId(compoundTag.m_128451_("AccessibilityOrder"))).isAccessibility()) {
            this.setAccessibility(order.accessibility());
        }
        if (compoundTag.m_128441_("BehaviourOrder") && (order = MobOrder.fromId(compoundTag.m_128451_("BehaviourOrder"))).isBehaviour()) {
            this.setBehaviourType(order.behaviour());
        }
        if (compoundTag.m_128441_("SpecificOrder") && (order = MobOrder.fromId(compoundTag.m_128451_("SpecificOrder"))).isSpecific()) {
            this.setSpecificOrderType(order.specific());
        }
        if (compoundTag.m_128441_("Variation")) {
            this.setVariation(MobVariation.valueOf(compoundTag.m_128461_("Variation").toUpperCase()));
        }
        if (compoundTag.m_128441_("Hunger")) {
            this.setHunger(compoundTag.m_128457_("Hunger"));
        }
        if (compoundTag.m_128441_("Stamina")) {
            this.setEnergy(compoundTag.m_128457_("Stamina"));
        }
        if (compoundTag.m_128441_("IsPregnant")) {
            this.setPregnant(compoundTag.m_128471_("IsPregnant"));
        }
        if (compoundTag.m_128425_("SaddleItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("SaddleItem"))).m_41619_() && itemstack.m_41720_() instanceof ItemDinoSaddle) {
            this.inventory.m_6836_(0, itemstack);
        }
        if (compoundTag.m_128425_("ArmorItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("ArmorItem"))).m_41619_() && itemstack.m_41720_() instanceof ItemDinoArmor) {
            this.inventory.m_6836_(1, itemstack);
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (((MobProperties)this.properties).isTamable()) {
            ItemStack itemStack = player.m_21120_(hand);
            if (!this.isTamed() && !this.m_9236_().f_46443_) {
                if (player.m_150110_().f_35937_) {
                    this.m_21828_(player);
                    return InteractionResult.SUCCESS;
                }
                if (this.canBeTamedBy(MobTameMethod.Type.FEED_FROM_HAND) && MobTameMethod.FeedWithItem.tameEatFromGround(player, this, itemStack)) {
                    return InteractionResult.SUCCESS;
                }
            }
            if (this.m_21830_((LivingEntity)player)) {
                ItemDinoArmor dinoArmor;
                ItemDinoSaddle dinoSaddle;
                Item item = itemStack.m_41720_();
                if (item instanceof ItemDinoSaddle && (dinoSaddle = (ItemDinoSaddle)item).canBeEquipped((LivingEntity)this)) {
                    return super.m_6071_(player, hand);
                }
                item = itemStack.m_41720_();
                if (item instanceof ItemDinoArmor && (dinoArmor = (ItemDinoArmor)item).canBeEquipped((LivingEntity)this)) {
                    return super.m_6071_(player, hand);
                }
                if (player.m_6047_()) {
                    TDELevelEvents.openInteractScreen(player, (LivingEntity)this);
                    return InteractionResult.SUCCESS;
                }
            }
            if ((this.m_21830_((LivingEntity)player) || this.getAccessibility() == MobOrder.Accessibility.PUBLIC) && !this.m_6162_() && ((MobProperties)this.properties).isRideable()) {
                if (((MobProperties)this.properties).isRequiresSaddle() && !this.isSaddled()) {
                    return super.m_6071_(player, hand);
                }
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
                player.m_20329_((Entity)this);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.energyBlockTime > 0) {
                --this.energyBlockTime;
            } else {
                this.restoreEnergy();
            }
            if (this.getMobRation() != null) {
                if (this.f_19797_ % (int)(4000.0f / this.m_21233_()) == 0 && !this.isHungry()) {
                    this.m_5634_(1.0f);
                }
                if (this.m_21223_() / this.m_21233_() <= 0.5f && this.getHunger() / this.getMaxHunger() >= 0.5f) {
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 2, false, false));
                    this.setHunger(Math.max(this.getHunger() - 5.0f, 0.0f));
                }
                this.randomStarve.tick((Mob)this);
            }
        }
        this.tickControlled = this.m_6688_() != null ? ++this.tickControlled : 0;
        this.bodyRotDeviation.update(0.25f);
        this.bodyRotDeviation.setTo((Object)((this.f_20883_ - this.f_20884_) * 2.0f));
        this.xRotDeviation.update(0.25f);
        this.xRotDeviation.setTo((Object)((this.f_19858_ - this.f_19860_) * 2.0f));
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(entity)) {
            double d0 = this.m_20186_() + this.m_6048_() + entity.m_6049_();
            moveFunction.m_20372_(entity, this.m_20185_(), d0, this.m_20189_());
        }
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType type) {
        return true;
    }

    public void onActionBegin(ActionState state) {
    }

    public void onActionEnd(ActionState state) {
    }

    public void onActionTick(ActionState state, int ticks) {
    }

    public void onServerMobStep(float stepPower) {
    }

    public Animator getOrCreateAnimator(BedrockModel model) {
        if (this.animator == null) {
            this.animator = new Animator(model).normalizationSpeed(5.0f);
        }
        return this.animator;
    }

    public BaseAnimal getNearestBaby(float radiusX, float radiusY, float radiusZ) {
        List list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_((double)radiusX, (double)radiusY, (double)radiusZ));
        BaseAnimal animal = null;
        double d0 = Double.MAX_VALUE;
        for (BaseAnimal animal1 : list) {
            double d1;
            if (animal1.m_146764_() >= 0 || (d1 = this.m_20280_((Entity)animal1)) > d0) continue;
            d0 = d1;
            animal = animal1;
        }
        return animal;
    }

    @Nullable
    public BaseAnimal getBreedOffspring(ServerLevel level, AgeableMob parent) {
        BaseAnimal baby = (BaseAnimal)this.m_6095_().m_20615_((Level)level);
        if (parent instanceof BaseAnimal) {
            BaseAnimal parentAnimal = (BaseAnimal)parent;
            baby.setVariation(parentAnimal.getVariation());
        }
        return baby;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (!this.m_20197_().isEmpty() && (this.isSaddled() || !((MobProperties)this.properties).isRequiresSaddle()) && (entity = (Entity)this.m_20197_().get(0)) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public void breakLeavesDropTrees() {
        BaseAnimal baseAnimal;
        if (!this.m_6162_() && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) && !this.m_9236_().f_46443_ && (baseAnimal = this) instanceof BaseRideableAnimal) {
            BaseRideableAnimal rideableAnimal = (BaseRideableAnimal)baseAnimal;
            if (((BaseRideableAnimal.Properties)rideableAnimal.getProperties()).isCanDropTrees()) {
                AABB aabb2 = rideableAnimal.getTreeFallBoundingBox();
                for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb2.f_82288_), (int)Mth.m_14107_((double)aabb2.f_82289_), (int)Mth.m_14107_((double)aabb2.f_82290_), (int)Mth.m_14107_((double)aabb2.f_82291_), (int)Mth.m_14107_((double)aabb2.f_82292_), (int)Mth.m_14107_((double)aabb2.f_82293_))) {
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    if (!blockstate.m_204336_(BlockTags.f_13106_) || !(this.getEnergy() > 5.0f) || !EntityFallingTree.createFallingTree(this.m_9236_(), blockpos, this.m_20182_(), 16)) continue;
                    this.consumeEnergy(5.0f);
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 1, false, false));
                    break;
                }
            }
            if (((BaseRideableAnimal.Properties)rideableAnimal.getProperties()).isCanBreakLeaves()) {
                int particleLimit = 0;
                AABB aabb = rideableAnimal.getLeavesBreakBoundingBox();
                for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    if (!blockstate.m_204336_(BlockTags.f_13035_)) continue;
                    if (particleLimit < 6) {
                        this.m_9236_().m_46961_(blockpos, false);
                        ++particleLimit;
                        continue;
                    }
                    this.m_9236_().m_7471_(blockpos, false);
                }
            }
        }
    }

    public boolean canLook() {
        return true;
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigatorNoSpin((Mob)this, level);
    }

    protected BodyRotationControl m_7560_() {
        return new BodyRotationControl((Mob)this);
    }

    public ActionStateMachine getActionStateMachine() {
        return this.stateMachine;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public boolean m_6573_(Player player) {
        if (this.m_6095_().m_204039_(TDETags.Entities.SMALL_ANIMAL) || this.m_6095_().m_204039_(TDETags.Entities.MEDIUM_ANIMAL)) {
            return this.m_21830_((LivingEntity)player);
        }
        return false;
    }

    public float m_6134_() {
        return super.m_6134_() * this.getAgeScale(0.0f);
    }

    public boolean m_6779_(LivingEntity target) {
        if (target == null) {
            return false;
        }
        if (target instanceof Player && this.m_9236_().m_46791_() == Difficulty.PEACEFUL || !target.m_142066_()) {
            return false;
        }
        if (this.isTamed() && this.getBehaviourType() != MobOrder.Behaviour.IGNORE && this.getMovementOrderType() != MobOrder.Movement.WAIT) {
            BaseAnimal animal;
            TamableAnimal tamableAnimal;
            if (target instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)target).m_21830_(this.m_269323_())) {
                return false;
            }
            if (target instanceof BaseAnimal && (animal = (BaseAnimal)target).m_21830_(this.m_269323_())) {
                return false;
            }
        }
        if (target instanceof Player && this.m_20363_((Entity)target)) {
            return false;
        }
        return !this.m_21830_(target) && !TDEUtils.isSameEntity((Entity)this, (Entity)target);
    }

    public boolean m_6549_(EntityType<?> type) {
        return true;
    }

    public float distanceToTarget() {
        if (this.m_5448_() == null) {
            return 0.0f;
        }
        return this.m_20270_((Entity)this.m_5448_());
    }

    public void randomGender(RandomSource randomSource) {
        if (RandomUtils.doWithChance((RandomSource)randomSource, (float)50.0f)) {
            this.setGender(GenderType.FEMALE);
        } else {
            this.setGender(GenderType.MALE);
        }
    }

    public void m_7334_(Entity entity) {
        BaseAnimal baseAnimal = this;
        if (baseAnimal instanceof BaseSleepingAnimal) {
            BaseSleepingAnimal sleepingDino = (BaseSleepingAnimal)baseAnimal;
            if (entity.getClass() == ((Object)((Object)this)).getClass() && sleepingDino.isSleepingOrResting()) {
                return;
            }
        }
        super.m_7334_(entity);
    }

    public void m_5997_(double deltaX, double deltaY, double deltaZ) {
        super.m_5997_(deltaX * (double)this.getPushModifier(), deltaY * (double)this.getPushModifier(), deltaZ * (double)this.getPushModifier());
    }

    private void setArmorEquipment(ItemStack itemStack) {
        this.setArmor(itemStack);
        if (!this.m_9236_().f_46443_) {
            ItemDinoArmor dinoArmor;
            int i;
            this.m_21051_(Attributes.f_22284_).m_22120_(ARMOR_MODIFIER_UUID);
            Item item = itemStack.m_41720_();
            if (item instanceof ItemDinoArmor && (i = (dinoArmor = (ItemDinoArmor)item).getProtection()) != 0) {
                this.m_21051_(Attributes.f_22284_).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Horse armor bonus", (double)i, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    public void updateContainerEquipment() {
        if (!this.m_9236_().f_46443_) {
            this.setSaddled(!this.inventory.m_8020_(0).m_41619_());
            this.setArmorEquipment(this.inventory.m_8020_(1));
            this.m_21409_(EquipmentSlot.CHEST, 0.0f);
        }
    }

    public void m_5757_(Container container) {
        boolean wasSaddled = this.isSaddled();
        ItemStack oldArmor = this.getArmor();
        this.updateContainerEquipment();
        ItemStack newArmor = this.getArmor();
        if (this.f_19797_ > 20) {
            if (!wasSaddled && this.isSaddled()) {
                this.m_5496_(SoundEvents.f_12034_, 0.5f, 1.0f);
            }
            if (newArmor.m_41720_() instanceof ItemDinoArmor && oldArmor != newArmor) {
                this.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
            }
        }
    }

    public SlotAccess m_141942_(int slotId) {
        int j;
        int i = slotId - 400;
        if (i >= 0 && i < 2 && i < this.inventory.m_6643_()) {
            if (i == 0) {
                return this.createEquipmentSlotAccess(this, i, itemStack -> {
                    if (itemStack.m_41619_()) {
                        return true;
                    }
                    Item patt29433$temp = itemStack.m_41720_();
                    if (patt29433$temp instanceof ItemDinoSaddle) {
                        ItemDinoSaddle saddle = (ItemDinoSaddle)patt29433$temp;
                        return saddle.canBeEquipped((LivingEntity)this);
                    }
                    return false;
                });
            }
            if (i == 1) {
                if (!((MobProperties)this.properties).isCanWearArmor()) {
                    return SlotAccess.f_147290_;
                }
                return this.createEquipmentSlotAccess(this, i, itemStack -> {
                    if (itemStack.m_41619_()) {
                        return true;
                    }
                    Item patt29995$temp = itemStack.m_41720_();
                    if (patt29995$temp instanceof ItemDinoArmor) {
                        ItemDinoArmor armor = (ItemDinoArmor)patt29995$temp;
                        return armor.canBeEquipped((LivingEntity)this);
                    }
                    return false;
                });
            }
        }
        return (j = slotId - 500 + 2) >= 2 && j < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)j) : super.m_141942_(slotId);
    }

    public void m_213583_(Player player) {
        if (!this.m_9236_().f_46443_ && (!this.m_20160_() || this.m_20363_((Entity)player)) && this.isTamed()) {
            TDEUtils.openDinoInventory(this, (ServerPlayer)player);
        }
    }

    public SimpleContainer createInventory() {
        SimpleContainer simplecontainer = this.getInventory();
        SimpleContainer inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        inventory.m_19164_((ContainerListener)this);
        if (this.getInventory() != null) {
            this.updateContainerEquipment();
        }
        this.setItemHandler(LazyOptional.of(() -> new InvWrapper((Container)inventory)));
        return inventory;
    }

    public SlotAccess createEquipmentSlotAccess(final BaseAnimal baseAnimal, final int slotId, final Predicate<ItemStack> itemStackPredicate) {
        return new SlotAccess(){

            public ItemStack m_142196_() {
                return baseAnimal.getInventory().m_8020_(slotId);
            }

            public boolean m_142104_(ItemStack itemStack) {
                if (!itemStackPredicate.test(itemStack)) {
                    return false;
                }
                baseAnimal.getInventory().m_6836_(slotId, itemStack);
                baseAnimal.updateContainerEquipment();
                return true;
            }
        };
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void setItemHandler(LazyOptional<?> itemHandler) {
        this.itemHandler = itemHandler;
    }

    public boolean hasInventoryChanged(Container container) {
        return this.inventory != container;
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public int getInventorySize() {
        return 2;
    }

    public boolean isArmored() {
        return !this.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    private void setArmor(ItemStack itemStack) {
        this.m_8061_(EquipmentSlot.CHEST, itemStack);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public void m_146762_(int age) {
        boolean wasBaby = this.m_6162_();
        super.m_146762_(age);
        this.f_19804_.m_135381_(DATA_AGE_IN_TICKS, (Object)age);
        if (wasBaby && !this.m_6162_()) {
            this.updateAttributes(true);
        } else if (!wasBaby && this.m_6162_()) {
            this.updateAttributes(false);
        }
    }

    public float getAgeScale(float partialTick) {
        float ageInTicks = (float)(24000 + this.getAgeInTicks()) + partialTick;
        float scale = MathUtils.clamp((float)(ageInTicks / 24000.0f), (float)0.5f, (float)1.0f);
        return scale;
    }

    public int getAgeInTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_AGE_IN_TICKS);
    }

    public void m_7350_(EntityDataAccessor<?> p_146754_) {
        super.m_7350_(p_146754_);
    }

    public void setGender(GenderType gender) {
        this.f_19804_.m_135381_(DATA_GENDER_TYPE, (Object)gender);
    }

    public GenderType getGender() {
        return (GenderType)((Object)this.f_19804_.m_135370_(DATA_GENDER_TYPE));
    }

    public MobOrder.Movement getMovementOrderType() {
        return (MobOrder.Movement)this.f_19804_.m_135370_(DATA_MOVEMENT_ORDER_TYPE);
    }

    public void setMovementOrderType(MobOrder.Movement order) {
        this.f_19804_.m_135381_(DATA_MOVEMENT_ORDER_TYPE, (Object)order);
        this.m_6710_(null);
    }

    public MobOrder.Eating getFoodOrderType() {
        return (MobOrder.Eating)this.f_19804_.m_135370_(DATA_FOOD_ORDER_TYPE);
    }

    public void setFoodOrderType(MobOrder.Eating order) {
        this.f_19804_.m_135381_(DATA_FOOD_ORDER_TYPE, (Object)order);
        this.m_6710_(null);
    }

    public MobOrder.Accessibility getAccessibility() {
        return (MobOrder.Accessibility)this.f_19804_.m_135370_(DATA_ACCESSIBILITY);
    }

    public void setAccessibility(MobOrder.Accessibility order) {
        this.f_19804_.m_135381_(DATA_ACCESSIBILITY, (Object)order);
    }

    public MobVariation getVariation() {
        return (MobVariation)((Object)this.f_19804_.m_135370_(DATA_VARIATION));
    }

    public void setVariation(MobVariation variation) {
        this.f_19804_.m_135381_(DATA_VARIATION, (Object)variation);
    }

    public MobOrder.Behaviour getBehaviourType() {
        return (MobOrder.Behaviour)this.f_19804_.m_135370_(DATA_BEHAVIOUR_TYPE);
    }

    public void setBehaviourType(MobOrder.Behaviour behaviourType) {
        this.f_19804_.m_135381_(DATA_BEHAVIOUR_TYPE, (Object)behaviourType);
        this.m_6710_(null);
    }

    public MobOrder.Specific getSpecificOrderType() {
        return (MobOrder.Specific)this.f_19804_.m_135370_(DATA_SPECIFIC_ORDER_TYPE);
    }

    public void setSpecificOrderType(MobOrder.Specific specialOrderType) {
        this.f_19804_.m_135381_(DATA_SPECIFIC_ORDER_TYPE, (Object)specialOrderType);
        this.m_6710_(null);
    }

    public boolean hasSpecificOrder(MobOrder.Specific type) {
        for (MobOrder.Specific specificOrder : this.specificOrders) {
            if (specificOrder != type) continue;
            return true;
        }
        return false;
    }

    public void addSpecificOrders(MobOrder.Specific ... orders) {
        ArrayList<MobOrder.Specific> finalOrders = new ArrayList<MobOrder.Specific>();
        for (MobOrder.Specific order : this.specificOrders) {
            finalOrders.add(order);
        }
        for (MobOrder.Specific order : orders) {
            finalOrders.add(order);
        }
        this.specificOrders = finalOrders.toArray(new MobOrder.Specific[finalOrders.size()]);
    }

    public MobOrder.Specific[] getSpecificOrders() {
        return this.specificOrders;
    }

    public LivingEntity getLastAttackTarget() {
        return this.lastAttackTarget;
    }

    public void setLastAttackTarget(LivingEntity lastAttackTarget) {
        this.lastAttackTarget = lastAttackTarget;
    }

    public ItemStack getLastEatenFood() {
        return this.lastEatenFood;
    }

    public void setLastEatenFood(ItemStack lastEatenFood) {
        this.lastEatenFood = lastEatenFood;
    }

    public boolean hasBaby() {
        if (this.baby != null) {
            return this.baby.m_6084_() && this.m_20280_((Entity)this.baby) < 100.0;
        }
        return this.baby != null;
    }

    public BaseAnimal getBaby() {
        return this.baby;
    }

    public void setParentOfBaby(BaseAnimal baby) {
        this.baby = baby;
    }

    public boolean m_21830_(LivingEntity livingEntity) {
        if (this.m_21805_() != null) {
            return TDEUtils.isSameEntity((Entity)this.m_269323_(), (Entity)livingEntity);
        }
        return false;
    }

    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SADDLED);
    }

    public void setSaddled(boolean value) {
        this.f_19804_.m_135381_(DATA_SADDLED, (Object)value);
    }

    public boolean isSaddleable() {
        return this.m_6084_() && !this.m_6162_() && this.isTamed();
    }

    public boolean isTamed() {
        return (Boolean)this.f_19804_.m_135370_(DATA_TAMED);
    }

    public void setTamed(boolean value) {
        if (value) {
            this.m_6710_(null);
        }
        this.f_19804_.m_135381_(DATA_TAMED, (Object)value);
        this.updateAttributes(value);
    }

    public boolean canBeTamedBy(MobTameMethod.Type type) {
        MobTameMethod tameMethod = ((MobProperties)this.getProperties()).getTameMethod();
        return tameMethod != null && tameMethod.isType(type);
    }

    public void m_21828_(Player player) {
        if (!this.isTamed() && ((MobProperties)this.getProperties()).isTamable()) {
            this.setTamed(true);
            this.m_21816_(player.m_20148_());
            TDELevelEvents.tame(player, (LivingEntity)this, true);
            player.m_213846_((Component)Component.m_237110_((String)TAME_MESSAGE, (Object[])new Object[]{this.m_5446_()}));
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)player, (Animal)this);
            }
        }
    }

    public boolean tameRandomly(Player player, boolean success) {
        if (!this.isTamed() && ((MobProperties)this.getProperties()).isTamable()) {
            TDELevelEvents.tame(player, (LivingEntity)this, success);
            if (success) {
                this.setTamed(true);
                this.m_21816_(player.m_20148_());
                player.m_213846_((Component)Component.m_237110_((String)TAME_MESSAGE, (Object[])new Object[]{this.m_5446_()}));
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)player, (Animal)this);
                }
                return true;
            }
        }
        return false;
    }

    public void updateAttributes(boolean canRestore) {
        double tamedMultiplier = (Double)TDECommonConfig.TAME_ATTRIBUTE_MULTIPLIER.get();
        double babyMultiplier = (Double)TDECommonConfig.AGE_ATTRIBUTE_MULTIPLIER.get();
        float damageMultiplier = this.isTamed() ? (float)tamedMultiplier : 1.0f;
        float hungerMultiplier = this.isTamed() ? (float)tamedMultiplier : 1.0f;
        float energyMultiplier = this.isTamed() ? (float)tamedMultiplier : 1.0f;
        float healthMultiplier = this.isTamed() ? (float)tamedMultiplier : 1.0f;
        float ageMultiplier = this.m_6162_() ? (float)babyMultiplier : 1.0f;
        AttributeUtils.setMultipliedBaseAttributeValue((LivingEntity)this, Attributes.f_22281_, ageMultiplier * damageMultiplier);
        AttributeUtils.setMultipliedBaseAttributeValue((LivingEntity)this, Attributes.f_22276_, ageMultiplier * healthMultiplier);
        AttributeUtils.setMultipliedBaseAttributeValue((LivingEntity)this, (Attribute)TDEAttributes.MAX_HUNGER.get(), ageMultiplier * hungerMultiplier);
        AttributeUtils.setMultipliedBaseAttributeValue((LivingEntity)this, (Attribute)TDEAttributes.MAX_ENERGY.get(), ageMultiplier * energyMultiplier);
        if (canRestore || this.m_21223_() > this.m_21233_()) {
            this.m_21153_(this.m_21233_());
        }
        if (canRestore || this.getHunger() > this.getMaxHunger()) {
            this.setHunger(this.getMaxHunger() / 2.0f);
        }
        if (canRestore || this.getEnergy() > this.getMaxEnergy()) {
            this.setEnergy(this.getMaxEnergy());
        }
    }

    public boolean doesKilledEntityHasDrop(LivingEntity killedEntity, Collection<ItemEntity> drops) {
        if (this.getMobRation().canBeEaten((LivingEntity)this, killedEntity)) {
            this.eat(this.getMaxHunger() / 4.0f);
            return false;
        }
        return true;
    }

    public void sensedExplosionOrLightning(BlockPos pos) {
    }

    public boolean applyInstantEffect(MobEffect mobEffect, Entity source, Entity owner, LivingEntity livingEntity) {
        return true;
    }

    public void restoreEnergy() {
        if (this.getEnergy() < this.getMaxEnergy()) {
            this.setEnergy(this.getEnergy() + 0.5f);
        }
    }

    public boolean consumeEnergy(float energy) {
        if (this.getEnergy() >= energy) {
            this.setEnergy(this.getEnergy() - energy);
            this.energyBlockTime = 10;
            return true;
        }
        return false;
    }

    public void setEnergy(float energy) {
        this.f_19804_.m_135381_(DATA_STAMINA, (Object)Float.valueOf(energy));
    }

    public float getEnergy() {
        return ((Float)this.f_19804_.m_135370_(DATA_STAMINA)).floatValue();
    }

    public float getMaxEnergy() {
        return (int)this.m_21133_((Attribute)TDEAttributes.MAX_ENERGY.get());
    }

    public void eat(float saturation) {
        this.setHunger(Math.min(this.getHunger() + saturation, this.getMaxHunger()));
        if (this.getHunger() == this.getMaxHunger()) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19601_, 1, 0, true, true));
        }
    }

    public float getMaxHunger() {
        return (int)this.m_21133_((Attribute)TDEAttributes.MAX_HUNGER.get());
    }

    public float getHunger() {
        return ((Float)this.f_19804_.m_135370_(DATA_HUNGER)).floatValue();
    }

    public void setHunger(float hunger) {
        this.f_19804_.m_135381_(DATA_HUNGER, (Object)Float.valueOf(hunger));
    }

    public boolean isHungry() {
        return this.getHunger() < this.getMaxHunger();
    }

    public MobFoodRation getMobRation() {
        return ((MobProperties)this.getProperties()).getFoodRation();
    }

    public boolean isPregnant() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PREGNANT);
    }

    public void setPregnant(boolean value) {
        this.f_19804_.m_135381_(DATA_PREGNANT, (Object)value);
    }

    public float getPushModifier() {
        return (float)((MobProperties)this.properties).getPushModifier().getDouble();
    }

    public float getStepHeight() {
        return (float)((MobProperties)this.properties).getStepHeight().getDouble();
    }

    public T getProperties() {
        return this.properties;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.parts;
    }

    public boolean isMultipartEntity() {
        return this.parts != null;
    }

    public double m_20204_() {
        return (double)this.m_20192_() < 0.1 ? 0.0 : 0.4;
    }

    public double getReachDistanceTo(Entity target, double reachModifier) {
        return (double)this.m_20205_() * reachModifier * (double)this.m_20205_() * reachModifier + (double)target.m_20205_();
    }

    public double getReachDistance(double reachModifier) {
        return (double)this.m_20205_() * reachModifier * (double)this.m_20205_() * reachModifier;
    }

    public int m_213860_() {
        return ((MobProperties)this.properties).getExperienceDrop().getInt();
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_5803_() {
        return false;
    }

    public boolean isResting() {
        return false;
    }

    public boolean isSleepingOrResting() {
        return this.m_5803_() || this.isResting();
    }

    public static boolean checkAnyMobSpawnRules(EntityType<? extends BaseAnimal> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        return pos.m_123342_() > level.m_5736_();
    }

    protected void m_21834_(boolean success) {
    }

    public boolean m_7757_(LivingEntity livingEntity, LivingEntity owner) {
        return true;
    }

    public boolean m_21827_() {
        return this.getMovementOrderType() == MobOrder.Movement.WAIT;
    }

    public void m_21839_(boolean value) {
    }

    static {
        DATA_AGE_IN_TICKS = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        DATA_TAMED = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        DATA_SADDLED = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        DATA_PREGNANT = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        DATA_HUNGER = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        DATA_STAMINA = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        DATA_GENDER_TYPE = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)((EntityDataSerializer)TDEEntityDataSerializers.GENDER_TYPE.get()));
        DATA_MOVEMENT_ORDER_TYPE = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)((EntityDataSerializer)TDEEntityDataSerializers.MOVEMENT_ORDER_TYPE.get()));
        DATA_FOOD_ORDER_TYPE = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)((EntityDataSerializer)TDEEntityDataSerializers.FOOD_ORDER_TYPE.get()));
        DATA_ACCESSIBILITY = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)((EntityDataSerializer)TDEEntityDataSerializers.ACCESSIBILITY.get()));
        DATA_SPECIFIC_ORDER_TYPE = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)((EntityDataSerializer)TDEEntityDataSerializers.SPECIFIC_ORDER_TYPE.get()));
        DATA_BEHAVIOUR_TYPE = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)((EntityDataSerializer)TDEEntityDataSerializers.BEHAVIOUR_TYPE.get()));
        DATA_VARIATION = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)((EntityDataSerializer)TDEEntityDataSerializers.MOB_VARIATION.get()));
    }
}

